/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.screen;

import android.content.Context;
import androidx.activity.ComponentActivity;
import com.qiniu.qplayer2ext.commonplayer.data.CommonPlayableParams;
import com.qiniu.qplayer2ext.commonplayer.data.CommonVideoParams;
import com.qiniu.qplayer2ext.commonplayer.data.DisplayOrientation;
import com.qiniu.qplayer2ext.commonplayer.gravitysensor.GravitySensorHandler;
import com.qiniu.qplayer2ext.commonplayer.gravitysensor.IGravitySensorChecker;
import com.qiniu.qplayer2ext.commonplayer.screen.HalfScreenAndFullScreenHandler;
import com.qiniu.qplayer2ext.commonplayer.screen.ICommonPlayerScreenChangedListener;
import com.qiniu.qplayer2ext.commonplayer.screen.ICommonPlayerScreenHandler;
import com.qiniu.qplayer2ext.commonplayer.screen.ScreenType;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u00052\u00020\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0017\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b \u0010!J\u0006\u0010\"\u001a\u00020\u0017J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/qiniu/qplayer2ext/commonplayer/screen/CommonPlayerScreenHandler;", "T3", "Lcom/qiniu/qplayer2ext/commonplayer/data/CommonPlayableParams;", "T4", "Lcom/qiniu/qplayer2ext/commonplayer/data/CommonVideoParams;", "Lcom/qiniu/qplayer2ext/commonplayer/gravitysensor/IGravitySensorChecker;", "Lcom/qiniu/qplayer2ext/commonplayer/screen/ICommonPlayerScreenHandler;", "mActivity", "Landroidx/activity/ComponentActivity;", "(Landroidx/activity/ComponentActivity;)V", "mCurrentPlayableParams", "Lcom/qiniu/qplayer2ext/commonplayer/data/CommonPlayableParams;", "mCurrentScreenType", "Lcom/qiniu/qplayer2ext/commonplayer/screen/ScreenType;", "mGravitySensorHandler", "Lcom/qiniu/qplayer2ext/commonplayer/gravitysensor/GravitySensorHandler;", "mHalfScreenAndFullScreenHandler", "Lcom/qiniu/qplayer2ext/commonplayer/screen/HalfScreenAndFullScreenHandler;", "mScreenChangedListeners", "Ljava/util/ArrayList;", "Lcom/qiniu/qplayer2ext/commonplayer/screen/ICommonPlayerScreenChangedListener;", "Lkotlin/collections/ArrayList;", "addScreenChangedListener", "", "listener", "getCurrentScreenType", "isGravityOrientationEnable", "", "orientation", "", "onPlayableParamsChanged", "playableParams", "onPlayableParamsChanged$qplayer2_ext_1_4_1_release", "(Lcom/qiniu/qplayer2ext/commonplayer/data/CommonPlayableParams;)V", "removeAllScreenChangedListeners", "removeScreenChangedListener", "switchScreenType", "screenType", "qplayer2-ext-1.4.1_release"})
public final class CommonPlayerScreenHandler<T3 extends CommonPlayableParams, T4 extends CommonVideoParams>
implements IGravitySensorChecker,
ICommonPlayerScreenHandler {
    @NotNull
    private final ComponentActivity mActivity;
    @NotNull
    private final HalfScreenAndFullScreenHandler mHalfScreenAndFullScreenHandler;
    @NotNull
    private final GravitySensorHandler mGravitySensorHandler;
    @NotNull
    private ScreenType mCurrentScreenType;
    @NotNull
    private final ArrayList<ICommonPlayerScreenChangedListener> mScreenChangedListeners;
    @Nullable
    private T3 mCurrentPlayableParams;

    public CommonPlayerScreenHandler(@NotNull ComponentActivity mActivity) {
        Intrinsics.checkNotNullParameter((Object)mActivity, (String)"mActivity");
        this.mActivity = mActivity;
        this.mHalfScreenAndFullScreenHandler = new HalfScreenAndFullScreenHandler(this.mActivity);
        this.mGravitySensorHandler = new GravitySensorHandler(this, (Context)this.mActivity, this);
        this.mCurrentScreenType = ScreenType.HALF_SCREEN;
        this.mScreenChangedListeners = new ArrayList();
    }

    @Override
    public void addScreenChangedListener(@NotNull ICommonPlayerScreenChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mScreenChangedListeners.add(listener);
    }

    @Override
    public void removeScreenChangedListener(@NotNull ICommonPlayerScreenChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mScreenChangedListeners.remove(listener);
    }

    public final void removeAllScreenChangedListeners() {
        this.mScreenChangedListeners.clear();
    }

    public final void onPlayableParamsChanged$qplayer2_ext_1_4_1_release(@NotNull T3 playableParams) {
        Intrinsics.checkNotNullParameter(playableParams, (String)"playableParams");
        this.mCurrentPlayableParams = playableParams;
    }

    @Override
    public void switchScreenType(@NotNull ScreenType screenType) {
        Intrinsics.checkNotNullParameter((Object)((Object)screenType), (String)"screenType");
        this.mCurrentScreenType = screenType;
        T3 T3 = this.mCurrentPlayableParams;
        if (T3 != null) {
            T3 T32;
            T3 playableParams = T32 = T3;
            boolean bl = false;
            this.mHalfScreenAndFullScreenHandler.switchScreen(this.mCurrentScreenType, ((CommonPlayableParams)playableParams).getDisplayOrientation());
            Iterable $this$forEach$iv = this.mScreenChangedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ICommonPlayerScreenChangedListener it = (ICommonPlayerScreenChangedListener)element$iv;
                boolean bl2 = false;
                it.onScreenTypeChanged(this.mCurrentScreenType);
            }
        }
    }

    @Override
    @NotNull
    public ScreenType getCurrentScreenType() {
        return this.mCurrentScreenType;
    }

    @Override
    public boolean isGravityOrientationEnable(int orientation) {
        T3 T3 = this.mCurrentPlayableParams;
        if (T3 != null) {
            T3 T32;
            T3 it = T32 = T3;
            boolean bl = false;
            switch (orientation) {
                case 1: {
                    return true;
                }
                case 9: {
                    if (this.mCurrentScreenType != ScreenType.FULL_SCREEN || ((CommonPlayableParams)it).getDisplayOrientation() != DisplayOrientation.VERTICAL) break;
                    return true;
                }
                case 0: {
                    if (((CommonPlayableParams)it).getDisplayOrientation() != DisplayOrientation.LANDSCAPE) break;
                    return true;
                }
                case 8: {
                    if (((CommonPlayableParams)it).getDisplayOrientation() != DisplayOrientation.LANDSCAPE) break;
                    return true;
                }
            }
        }
        return false;
    }
}

