/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.qplayer2ext.commonplayer.view;

import android.content.Context;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;

public class FixedWidthTextView
extends AppCompatTextView {
    private CharSequence mPrevText;
    private boolean mTextLengthChanged = true;

    public FixedWidthTextView(Context context) {
        super(context);
    }

    public FixedWidthTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FixedWidthTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.mTextLengthChanged = this.mPrevText == null || text == null || this.mPrevText.length() != text.length();
        this.mPrevText = text;
        TextPaint paint = this.getPaint();
        if (!this.mTextLengthChanged && text != null && paint != null) {
            this.mTextLengthChanged = paint.measureText(text, 0, text.length()) > (float)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight());
        }
        super.setText(text, type);
        this.mTextLengthChanged = false;
    }

    public void requestLayout() {
        if (!this.mTextLengthChanged) {
            return;
        }
        super.requestLayout();
    }
}

