/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis;

import com.qlangtech.tis.OssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class AliyunOSSCfg {
    public static final String KEY_SYS_USER_HOME = "user.home";
    public static final String KEY_ALIYUN_OSS_DIR = "aliyun-oss";
    private static AliyunOSSCfg instance;
    Map<String, OssConfig> ossRepo;

    private AliyunOSSCfg() {
    }

    public OssConfig getOss(String cfgName) {
        return Objects.requireNonNull(this.ossRepo.get(cfgName), "cfgName:" + cfgName + " relevant OssConfig can not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliyunOSSCfg getInstance() {
        if (instance != null) return instance;
        Class<AliyunOSSCfg> clazz = AliyunOSSCfg.class;
        synchronized (AliyunOSSCfg.class) {
            if (instance != null) return instance;
            instance = new AliyunOSSCfg();
            AliyunOSSCfg.instance.ossRepo = new HashMap<String, OssConfig>();
            HashMap<String, OssConfig> ossRepo = AliyunOSSCfg.instance.ossRepo;
            File ossCfgRoot = new File(System.getProperty(KEY_SYS_USER_HOME), KEY_ALIYUN_OSS_DIR);
            Collection cfgs = FileUtils.listFiles((File)ossCfgRoot, (String[])new String[]{"properties"}, (boolean)false);
            for (File cfg : cfgs) {
                OssConfig oss = AliyunOSSCfg.createOssConfig(cfg);
                ossRepo.put(oss.cfgName, oss);
            }
            AliyunOSSCfg.instance.ossRepo = Collections.unmodifiableMap(ossRepo);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static OssConfig createOssConfig(File cfgFile) {
        if (!cfgFile.exists()) {
            throw new IllegalStateException("oss config file is not exist:" + cfgFile.getAbsoluteFile() + "\n config.properties template is ");
        }
        Properties props = new Properties();
        try (FileInputStream reader = FileUtils.openInputStream((File)cfgFile);){
            props.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String endpoint = AliyunOSSCfg.getProp(props, "endpoint");
        String accessKeyId = AliyunOSSCfg.getProp(props, "accessKey");
        String secretKey = AliyunOSSCfg.getProp(props, "secretKey");
        String bucketName = AliyunOSSCfg.getProp(props, "bucketName");
        OssConfig oss = new OssConfig(StringUtils.substringBefore((String)cfgFile.getName(), (String)"."));
        oss.setAccessId(accessKeyId);
        oss.setBucket(bucketName);
        oss.setEndpoint(endpoint);
        oss.setAccessSecret(secretKey);
        oss.validate();
        return oss;
    }

    private static String getProp(Properties props, String key) {
        String value = props.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("key:" + key + " relevant value can not be null");
        }
        return value;
    }
}

