/**
 * 
 */
package com.qlangtech.tis.ibatis.util;

import java.sql.SQLException;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;

/**
 * @author 百岁（baisui@taobao.com）
 * @date 2012-8-2
 */
public class BooleanYorNConvertCallback implements TypeHandlerCallback {

	public static final String YES = "Y";

	public void setParameter(ParameterSetter setter, Object parameter)
			throws SQLException {
		setter.setString(((Boolean) parameter) ? YES : "N");
	}

	public Object getResult(ResultGetter getter) throws SQLException {
		if ("N".equalsIgnoreCase(getter.getString())) {
			return Boolean.FALSE;
		} else

		if (YES.equalsIgnoreCase(getter.getString())) {
			return Boolean.TRUE;
		}
		return Boolean.TRUE;
	}

	public Object valueOf(String s) {
		return "N".equalsIgnoreCase(s);
	}

}
