package com.qlangtech.tis.realtime.transfer;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;



public abstract class AbstractRowValueGetter implements IRowValueGetter {

	// @Override
	// public String getColumn(String key) {
	// try {
	// return BeanUtils.getProperty(this,
	// BasicPojoConsumer.removeUnderline(key).toString());
	// } catch (Exception e) {
	// throw new RuntimeException(e);
	// }
	// }

//	/**
//	 * 为groovy使用
//	 *
//	 * @param name
//	 * @return
//	 */
//	public Object getProperty(String name) {
//		return this.getProperty(name);
//	}

	@Override
	public String getColumn(String key) {
		try {
			PropertyUtilsBean bean = BeanUtilsBean.getInstance().getPropertyUtils();
			String k = removeUnderline(key).toString();

			if (!bean.isReadable(this, k)) {
				return null;
			}

			Object p = bean.getProperty(this, k);
			if (p == null) {
				return null;
			}

			if (p != null && p instanceof Boolean) {
				return ((Boolean) p) ? "1" : "0";
			} else {
				return String.valueOf(p); //BeanUtils.getProperty(this, k);
			}

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static StringBuffer removeUnderline(String value) {
		StringBuffer parsedName = new StringBuffer();
		char[] nameAry = value.toCharArray();
		boolean findUnderChar = false;
		for (int i = 0; i < nameAry.length; i++) {
			if (nameAry[i] == '_') {
				findUnderChar = true;
				// parsedName.append('_').append(Character.toLowerCase(nameAry[i]));
			} else {
				if (findUnderChar) {
					parsedName.append(Character.toUpperCase(nameAry[i]));
					findUnderChar = false;
				} else {
					parsedName.append(nameAry[i]);
				}
			}
		}
		return parsedName;
	}

}
