/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.CucumberStepMatcher;
import com.qmetry.qaf.automation.gson.GsonDeserializerObjectWrapper;
import com.qmetry.qaf.automation.gson.ObjectWrapper;
import com.qmetry.qaf.automation.step.BDDStepMatcher;
import com.qmetry.qaf.automation.step.BDDStepMatcherFactory;
import com.qmetry.qaf.automation.step.BaseTestStep;
import com.qmetry.qaf.automation.step.QAFTestStepArgumentFormatter;
import com.qmetry.qaf.automation.step.QAFTestStepArgumentFormatterImpl;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.util.ClassUtil;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.RegularExpression;
import io.cucumber.datatable.DataTable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.text.StrSubstitutor;

public class CucumberStep
extends BaseTestStep {
    private static final ExpressionFactory FACTORY = new ExpressionFactory(new ParameterTypeRegistry(Locale.ENGLISH));
    private StepDefinition s;

    public CucumberStep(StepDefinition s) {
        super(s.toString(), CucumberStep.getPattern(s), new Object[0]);
        this.s = s;
        if (FACTORY.createExpression(s.getPattern()) instanceof RegularExpression) {
            this.setStepMatcher((BDDStepMatcher)new BDDStepMatcherFactory.GherkinStepMatcher());
        } else {
            this.setStepMatcher((BDDStepMatcher)new CucumberStepMatcher());
        }
    }

    private static String getPattern(StepDefinition s) {
        Type last;
        String pattern = s.getPattern();
        List params = s.parameterInfos();
        if (null != params && !params.isEmpty() && ClassUtil.isAssignableFrom((Type)(last = ((ParameterInfo)params.get(params.size() - 1)).getType()), DataTable.class)) {
            pattern = pattern + "{string}";
        }
        return pattern;
    }

    public String getSignature() {
        return this.s.getLocation();
    }

    public TestStep clone() {
        CucumberStep cloneObj = new CucumberStep(this.s);
        if (null != this.actualArgs) {
            cloneObj.actualArgs = (Object[])this.actualArgs.clone();
        }
        return cloneObj;
    }

    protected Object doExecute() {
        try {
            Object[] args = this.processArgs(this.s.parameterInfos(), this.actualArgs);
            this.s.execute(args);
        }
        catch (CucumberInvocationTargetException cie) {
            Throwable cause = cie.getInvocationTargetExceptionCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            AutomationError ae = new AutomationError(cause + "-" + this.s.getLocation(), cause);
            ae.setStackTrace(cause.getStackTrace());
            throw ae;
        }
        catch (Exception e) {
            throw new AutomationError(this.s.getLocation(), e.getCause());
        }
        return null;
    }

    protected Object[] processArgs(List<ParameterInfo> list, Object ... objects) {
        int noOfParams = list.size();
        if (noOfParams == 0) {
            return null;
        }
        Object[] params = new Object[noOfParams];
        Map context = this.getStepExecutionTracker().getContext();
        try {
            if (noOfParams == objects.length - 1 && list.get(noOfParams - 1).getType().getClass().isArray()) {
                System.arraycopy(objects, 0, params, 0, objects.length);
                params[noOfParams - 1] = "[]";
            } else {
                System.arraycopy(objects, 0, params, 0, noOfParams);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Wrong number of parameters, Expected " + noOfParams + " parameters but Actual is " + (objects == null ? "0" : Integer.valueOf(objects.length)));
        }
        this.description = StrSubstitutor.replace((Object)this.description, (Map)context);
        this.description = ConfigurationManager.getBundle().getSubstitutor().replace(this.description);
        Object formatter = new QAFTestStepArgumentFormatterImpl();
        for (int i = 0; i < noOfParams; ++i) {
            Type paramType = list.get(i).getType();
            context.put("__paramType", paramType);
            context.put("__paramIndex", i);
            if (paramType.getTypeName().endsWith("DataTable")) {
                formatter = new DataTableFormattor();
            }
            params[i] = formatter.format(params[i], context);
            if (params[i].getClass().isAssignableFrom((Class)paramType) || !String.class.isAssignableFrom((Class)paramType)) continue;
            params[i] = new Gson().toJson(params[i]);
        }
        return params;
    }

    static class DataTableFormattor
    implements QAFTestStepArgumentFormatter<Object> {
        private static final Gson gson = new GsonBuilder().setDateFormat("dd-MM-yyyy").registerTypeAdapter(ObjectWrapper.class, (Object)new GsonDeserializerObjectWrapper(Object.class)).create();

        DataTableFormattor() {
        }

        public Object format(Object value, Map<String, Object> context) {
            Class paramType = (Class)context.get("__paramType");
            if (value instanceof String) {
                String pstr = (String)value;
                if (pstr.startsWith("${") && pstr.endsWith("}")) {
                    String pname = pstr.substring(2, pstr.length() - 1);
                    value = context.containsKey(pstr) ? context.get(pstr) : (context.containsKey(pname) ? context.get(pname) : (ConfigurationManager.getBundle().containsKey(pstr) ? this.getObject(pstr, paramType) : this.getPropValue(pname, paramType)));
                } else if (pstr.indexOf("$") >= 0) {
                    pstr = StrSubstitutor.replace((Object)pstr, context);
                    value = ConfigurationManager.getBundle().getSubstitutor().replace(pstr);
                }
            }
            String strVal = value instanceof String ? String.valueOf(value) : gson.toJson(value);
            strVal = ConfigurationManager.getBundle().getSubstitutor().replace(strVal);
            strVal = StrSubstitutor.replace((Object)strVal, context);
            ObjectWrapper w = (ObjectWrapper)gson.fromJson(strVal, ObjectWrapper.class);
            Object obj = w.getObject();
            List<List<String>> list = this.createListFromVal(obj);
            DataTable table = DataTable.create(list);
            return table;
        }

        private List<List<String>> createListFromVal(Object value) {
            ArrayList<List<String>> valueToReturn = new ArrayList<List<String>>();
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof Map) {
                Set row1 = ((Map)list.get(0)).keySet();
                valueToReturn.add(new LinkedList(row1));
                for (Object o : list) {
                    LinkedList<String> row = new LinkedList<String>();
                    for (Object item : ((Map)o).values()) {
                        row.add(item.toString());
                    }
                    valueToReturn.add(row);
                }
            } else {
                for (Object item : list) {
                    valueToReturn.add(Arrays.asList(item.toString()));
                }
            }
            return valueToReturn;
        }

        private Object getPropValue(String pname, Class<?> paramType) {
            Configuration o = ConfigurationManager.getBundle().subset(pname);
            if (o instanceof HierarchicalConfiguration && ((HierarchicalConfiguration)o).getRoot().getValue() == null && ((HierarchicalConfiguration)o).getRoot().getChildrenCount() > 0) {
                return new ConfigurationMap(ConfigurationManager.getBundle().subset(pname));
            }
            return this.getObject(pname, paramType);
        }

        private Object getObject(String key, Class<?> paramType) {
            Object o = ConfigurationManager.getBundle().getProperty(key);
            if (null != o && o.toString().indexOf("${") >= 0) {
                String ref = o.toString();
                if (ref.startsWith("${") && ref.toString().endsWith("}")) {
                    String pname = ref.substring(2, ref.length() - 1);
                    return this.getPropValue(pname, paramType);
                }
                return ConfigurationManager.getBundle().getSubstitutor().replace(ref);
            }
            if (null == o || o.getClass().isAssignableFrom(paramType)) {
                return o;
            }
            if (paramType.isArray()) {
                return ConfigurationManager.getBundle().getList(key).toArray();
            }
            if (o instanceof List) {
                return ((List)o).get(0);
            }
            return o;
        }
    }
}

