/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.step.BDDStepMatcherFactory;
import io.cucumber.core.exception.CucumberException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberStepMatcher
extends BDDStepMatcherFactory.DefaultBDDStepMatcher {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\\\\\\\)?\\{([^}]*)\\}");
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("(\\\\)?\\(([^)]+)\\)");
    private static final Pattern ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP = Pattern.compile("([^\\s^/]+)((/[^\\s^/]+)+)");
    private static final String ESCAPE = "\\";
    private static final String PARAMETER_TYPES_CANNOT_BE_ALTERNATIVE = "Parameter types cannot be alternative: ";
    private static final String PARAMETER_TYPES_CANNOT_BE_OPTIONAL = "Parameter types cannot be optional: ";

    public boolean matches(String stepDescription, String stepCall, Map<String, Object> context) {
        stepDescription = CucumberStepMatcher.processOptional(stepDescription);
        stepDescription = CucumberStepMatcher.processAlternation(stepDescription);
        return super.matches(stepDescription, stepCall, context);
    }

    public List<String[]> getArgsFromCall(String stepDescription, String stepCall, Map<String, Object> context) {
        stepDescription = CucumberStepMatcher.processOptional(stepDescription);
        stepDescription = CucumberStepMatcher.processAlternation(stepDescription);
        return super.getArgsFromCall(stepDescription, stepCall, context);
    }

    private static String processOptional(String expression) {
        Matcher matcher = OPTIONAL_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameterPart = matcher.group(2);
            String grp1 = matcher.group(1);
            if (ESCAPE.equals(grp1)) continue;
            CucumberStepMatcher.checkNotParameterType(parameterPart, PARAMETER_TYPES_CANNOT_BE_OPTIONAL);
            matcher.appendReplacement(sb, "(?:" + parameterPart + ")?");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String processAlternation(String expression) {
        Matcher matcher = ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = matcher.group(0).replace('/', '|').replaceAll("\\\\\\|", "/");
            if (replacement.contains("|")) {
                for (String part : replacement.split("\\|")) {
                    CucumberStepMatcher.checkNotParameterType(part, PARAMETER_TYPES_CANNOT_BE_ALTERNATIVE);
                }
                matcher.appendReplacement(sb, "(?:" + replacement + ")");
                continue;
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static void checkNotParameterType(String s, String message) {
        Matcher matcher = PARAMETER_PATTERN.matcher(s);
        if (matcher.find()) {
            throw new CucumberException(message + s);
        }
    }
}

