/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.cucumber.CucumberStep;
import com.qmetry.qaf.automation.cucumber.ObjectFactoryImpl;
import com.qmetry.qaf.automation.cucumber.QAFBackend;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.ObjectFactory;
import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Options;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class CucumberStepsFinder
implements Glue {
    private static final String CUCUMBER_BACKENDS = "cucumber.runtime.backend";
    private static final String CUCUMBER_GLUE = "cucumber.runtime.glue";
    private static final ObjectFactoryServiceLoader serviceLoader = new ObjectFactoryServiceLoader((Options)RuntimeOptions.defaultOptions());
    private static final ObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(serviceLoader);

    public void addStepDefinition(StepDefinition stepDefinition) {
        CucumberStep cucumberStep = new CucumberStep(stepDefinition);
        ConfigurationManager.getStepMapping().put(cucumberStep.getName().toUpperCase(), cucumberStep);
    }

    public void addBeforeHook(HookDefinition beforeHook) {
    }

    public void addAfterHook(HookDefinition afterHook) {
    }

    public void addBeforeStepHook(HookDefinition beforeStepHook) {
    }

    public void addAfterStepHook(HookDefinition afterStepHook) {
    }

    public void addParameterType(ParameterTypeDefinition parameterTypeDefinition) {
    }

    public void addDataTableType(DataTableTypeDefinition dataTableTypeDefinition) {
    }

    public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
    }

    public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
    }

    public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
    }

    public void addDocStringType(DocStringTypeDefinition docStringTypeDefinition) {
    }

    public static void buildBackendWorlds() {
        try {
            Collection<? extends Backend> backends = CucumberStepsFinder.getBackends();
            objectFactorySupplier.get().start();
            for (Backend backend : backends) {
                backend.buildWorld();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disposeBackendWorlds() {
        try {
            Collection<? extends Backend> backends = CucumberStepsFinder.getBackends();
            for (Backend backend : backends) {
                backend.disposeWorld();
            }
            objectFactorySupplier.get().stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Collection<? extends Backend> getBackends() {
        Collection backends = (Collection)((QAFTestBase)TestBaseProvider.instance().get()).getContext().getObject(CUCUMBER_BACKENDS);
        if (null == backends) {
            backends = new BackendServiceLoader(() -> Thread.currentThread().getContextClassLoader(), objectFactorySupplier).get().stream().filter(b -> !(b instanceof QAFBackend)).collect(Collectors.toList());
            ((QAFTestBase)TestBaseProvider.instance().get()).getContext().setProperty(CUCUMBER_BACKENDS, (Object)backends);
            CucumberStepsFinder glue = new CucumberStepsFinder();
            ((QAFTestBase)TestBaseProvider.instance().get()).getContext().setProperty(CUCUMBER_GLUE, (Object)glue);
            ArrayList<URI> uris = new ArrayList<URI>();
            for (String pkg : ConfigurationManager.getBundle().getStringArray(ApplicationProperties.STEP_PROVIDER_PKG.key)) {
                uris.add(GluePath.parse((String)pkg));
            }
            for (Backend backend : CucumberStepsFinder.getBackends()) {
                backend.loadGlue((Glue)glue, uris);
            }
            if (!objectFactorySupplier.get().getClass().getName().endsWith("DefaultJavaObjectFactory")) {
                ObjectFactoryImpl objFactoryImpl = new ObjectFactoryImpl(objectFactorySupplier);
                ObjectFactory.INSTANCE.setFactory((ObjectFactory)objFactoryImpl);
            }
        }
        return backends;
    }
}

