/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.step.DefaultObjectFactory;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class ObjectFactoryImpl
implements com.qmetry.qaf.automation.step.ObjectFactory {
    private static final Log logger = LogFactoryImpl.getLog(ObjectFactoryImpl.class);
    private ObjectFactorySupplier supplier;

    public ObjectFactoryImpl(ObjectFactorySupplier supplier) {
        this.supplier = supplier;
    }

    public <T> T getObject(Class<T> cls) throws Exception {
        ObjectFactory objectFactory = this.supplier.get();
        try {
            return (T)objectFactory.getInstance(cls);
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to crete obect of class[" + cls + "] using [" + objectFactory.getClass() + "]. Using default qaf obect factory as fallback"));
            return (T)new DefaultObjectFactory().getObject(cls);
        }
    }

    public void setFactory(ObjectFactorySupplier supplier) {
        this.supplier = supplier;
    }
}

