/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.QAFStepDefinition;
import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.NotYetImplementedException;
import com.qmetry.qaf.automation.step.TestStep;
import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.datatable.DataTable;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class QAFBackend
implements Backend {
    private final Lookup lookup;
    private final Container container;

    QAFBackend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderSupplier) {
        this.lookup = lookup;
        this.container = container;
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        Map steps = ConfigurationManager.getStepMapping();
        HashSet<String> names = new HashSet<String>();
        for (TestStep step : steps.values()) {
            if (!names.add(step.getDescription().replaceAll("\\{[a-zA-Z0-9_-]+\\}", "{string}"))) continue;
            glue.addStepDefinition((StepDefinition)new QAFStepDefinition(step, this.lookup));
            if (!(step instanceof JavaStep)) continue;
            this.container.addClass(((JavaStep)step).getMethod().getDeclaringClass());
        }
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public Snippet getSnippet() {
        return new QAFSnippet();
    }

    class QAFSnippet
    implements Snippet {
        QAFSnippet() {
        }

        public MessageFormat template() {
            return new MessageFormat("@QAFTestStep(\"{1}\")\npublic void {2}({3}) '{'\n    // {4}\n{5}    throw new " + NotYetImplementedException.class.getName() + "();\n'}'");
        }

        public String tableHint() {
            return "";
        }

        public String arguments(Map<String, Type> arguments) {
            return arguments.entrySet().stream().map(argType -> this.getArgType((Type)argType.getValue()) + " " + (String)argType.getKey()).collect(Collectors.joining(", "));
        }

        private String getArgType(Type argType) {
            if (argType instanceof Class) {
                Class cType = (Class)argType;
                if (cType.equals(DataTable.class)) {
                    return cType.getName();
                }
                return cType.getSimpleName();
            }
            return argType.toString();
        }

        public String escapePattern(String pattern) {
            return pattern.replace("\\", "\\\\").replace("\"", "\\\"");
        }
    }
}

