/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.cucumber.QAFReporter;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2PickleWrapper;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.ReportUtils;
import com.qmetry.qaf.automation.util.Reporter;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class QAFCucumberPlugin
implements ConcurrentEventListener {
    private static final Log logger = LogFactoryImpl.getLog(QAFCucumberPlugin.class);
    private EventHandler<EmbedEvent> embedEventHandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent event) {
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            if (event.getTestStep() instanceof PickleStepTestStep) {
                QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
                ArrayList allResults = new ArrayList(stb.getCheckPointResults());
                ArrayList allCommands = new ArrayList(stb.getLog());
                stb.getCheckPointResults().clear();
                stb.getLog().clear();
                stb.getContext().setProperty("allResults", allResults);
                stb.getContext().setProperty("allCommands", allCommands);
            }
        }
    };
    private EventHandler<TestStepFinished> stepfinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            if (event.getTestStep() instanceof PickleStepTestStep) {
                this.logStep((PickleStepTestStep)event.getTestStep(), event);
            }
        }

        private void logStep(PickleStepTestStep testStep, TestStepFinished event) {
            Result result = event.getResult();
            String stepText = testStep.getStep().getKeyWord() + testStep.getStep().getText();
            Long duration = result.getDuration().toMillis();
            QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
            if (result.getError() != null) {
                CheckpointResultBean failureCheckpoint = new CheckpointResultBean();
                failureCheckpoint.setMessage(result.getError().getMessage());
                failureCheckpoint.setType(MessageTypes.Fail);
                stb.getCheckPointResults().add(failureCheckpoint);
            }
            if (result.getStatus().is(Status.UNDEFINED)) {
                stepText = stepText + ": Not Found";
                stb.addVerificationError(event.getTestStep().getCodeLocation() + "TestStep implementation not found");
            }
            MessageTypes type = result.getStatus().is(Status.PASSED) && this.getStepMessageType(stb.getCheckPointResults()).isFailure() ? MessageTypes.TestStepFail : this.getStepMessageType(result.getStatus(), QAFCucumberPlugin.this.isDryRun(event.getTestCase()));
            LoggingBean stepLogBean = new LoggingBean(testStep.getPattern(), testStep.getDefinitionArgument().stream().map(a -> a.getValue()).collect(Collectors.toList()).toArray(new String[0]), result.getStatus().name());
            stepLogBean.setSubLogs(new ArrayList(stb.getLog()));
            CheckpointResultBean stepResultBean = new CheckpointResultBean();
            stepResultBean.setMessage(stepText);
            stepResultBean.setSubCheckPoints(new ArrayList(stb.getCheckPointResults()));
            stepResultBean.setDuration(duration.intValue());
            stepResultBean.setType(type);
            ArrayList allResults = (ArrayList)stb.getContext().getObject("allResults");
            ArrayList allCommands = (ArrayList)stb.getContext().getObject("allCommands");
            stb.getContext().clearProperty("allResults");
            stb.getContext().clearProperty("allCommands");
            allResults.add(stepResultBean);
            stb.getCheckPointResults().clear();
            stb.getCheckPointResults().addAll(allResults);
            allCommands.add(stepLogBean);
            stb.getLog().clear();
            stb.getLog().addAll(allCommands);
        }

        private MessageTypes getStepMessageType(List<CheckpointResultBean> subSteps) {
            MessageTypes type = MessageTypes.TestStepPass;
            for (CheckpointResultBean subStep : subSteps) {
                type = MessageTypes.TestStepPass;
                if (StringMatcher.containsIgnoringCase((String)"fail").match(subStep.getType())) {
                    return MessageTypes.TestStepFail;
                }
                if (!StringMatcher.containsIgnoringCase((String)"warn").match(subStep.getType())) continue;
                type = MessageTypes.Warn;
            }
            return type;
        }

        private MessageTypes getStepMessageType(Status status, boolean isDryRun) {
            switch (status) {
                case PASSED: {
                    return MessageTypes.TestStepPass;
                }
                case FAILED: 
                case UNDEFINED: {
                    return MessageTypes.TestStepFail;
                }
                case AMBIGUOUS: {
                    return MessageTypes.Warn;
                }
            }
            if (isDryRun) {
                return MessageTypes.TestStepPass;
            }
            return MessageTypes.TestStep;
        }
    };
    private EventHandler<TestCaseStarted> tcStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            BDD2PickleWrapper bdd2Pickle = QAFCucumberPlugin.getBdd2Pickle(event.getTestCase());
            bdd2Pickle.getMetaData().put("reference", new File("./").getAbsoluteFile().getParentFile().toURI().relativize(event.getTestCase().getUri()).getPath());
            QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
            stb.getLog().clear();
            stb.clearVerificationErrors();
            stb.getCheckPointResults().clear();
        }
    };
    private EventHandler<TestCaseFinished> tcfinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            try {
                TestCase tc = event.getTestCase();
                BDD2PickleWrapper bdd2Pickle = QAFCucumberPlugin.getBdd2Pickle(tc);
                boolean isDryRun = QAFCucumberPlugin.this.isDryRun(tc);
                ConfigurationManager.getBundle().setProperty(ApplicationProperties.DRY_RUN_MODE.key, (Object)isDryRun);
                Result result = event.getResult();
                Throwable throwable = result.getError();
                QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
                if (isDryRun) {
                    String vresult;
                    HashMap<String, Object> metadata = new HashMap<String, Object>(bdd2Pickle.getMetaData());
                    if (null != bdd2Pickle.getTestData()) {
                        metadata.putAll(bdd2Pickle.getTestData());
                    }
                    if (StringUtil.isNotBlank((String)(vresult = MetaDataScanner.applyMetaRule(metadata)))) {
                        throwable = new AutomationError("Metadata rule failure:" + vresult);
                        stb.addVerificationError(throwable);
                    }
                }
                if (stb.getVerificationErrors() > 0 && (result.getStatus().is(Status.PASSED) || isDryRun)) {
                    this.setStauts(event, null != throwable ? result.getStatus() : Status.FAILED, throwable);
                } else if (isDryRun && null == throwable) {
                    this.setStauts(event, Status.PASSED, throwable);
                }
                if (!isDryRun && !result.getStatus().is(Status.PASSED)) {
                    if (throwable instanceof AutomationError) {
                        this.setStauts(event, Status.SKIPPED, throwable);
                    }
                    ReportUtils.setScreenshot((Throwable)throwable);
                }
                this.deployResult(bdd2Pickle, tc, result);
                String useSingleSeleniumInstance = ConfigurationManager.getBundle().getString("selenium.singletone", "");
                if (useSingleSeleniumInstance.toUpperCase().startsWith("M")) {
                    stb.tearDown();
                }
            }
            catch (Exception e) {
                logger.error((Object)"QAFCucumberPlugin unable to process TestCaseFinished event", (Throwable)e);
            }
        }

        private void setStauts(TestCaseFinished event, Status status, Throwable error) {
            Result result = event.getResult();
            if (null == error) {
                error = result.getError();
            }
            try {
                result.setStatus(status);
                result.setError(error);
            }
            catch (Throwable e) {
                logger.debug((Object)("Unable to set status " + status + ": " + e.getMessage()));
                result = new Result(status, result.getDuration(), error);
                try {
                    ClassUtil.setField((String)"result", (Object)event, (Object)result);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Unable to set status " + status + ": " + t.getMessage()));
                }
            }
        }

        private void deployResult(BDD2PickleWrapper bdd2Pickle, TestCase tc, Result eventresult) {
            try {
                if (ResultUpdator.getResultUpdatorsCnt() > 0) {
                    TestCaseRunResult.Status result = eventresult.getStatus() == Status.PASSED ? TestCaseRunResult.Status.PASS : (eventresult.getStatus() == Status.FAILED ? TestCaseRunResult.Status.FAIL : TestCaseRunResult.Status.SKIPPED);
                    long stTime = System.currentTimeMillis() - eventresult.getDuration().toMillis();
                    HashMap<String, Object> executionInfo = new HashMap<String, Object>();
                    executionInfo.put("testName", ConfigurationManager.getBundle().getString("testname", "BDD2"));
                    executionInfo.put("suiteName", QAFReporter.SUITENAME);
                    executionInfo.put("env", ConfigurationConverter.getMap((Configuration)ConfigurationManager.getBundle().subset("env")));
                    if (null != bdd2Pickle && null != bdd2Pickle.getMetaData()) {
                        Object[] objectArray;
                        List steps = bdd2Pickle.getSteps().stream().map(s -> s.getText()).collect(Collectors.toList());
                        if (bdd2Pickle.getTestData() != null) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = bdd2Pickle.getTestData();
                        } else {
                            objectArray = null;
                        }
                        Object[] testdata = objectArray;
                        TestCaseRunResult testCaseRunResult = new TestCaseRunResult(result, bdd2Pickle.getMetaData(), testdata, executionInfo, steps, stTime, false, true);
                        testCaseRunResult.setClassName(bdd2Pickle.getMetaData().get("reference").toString());
                        testCaseRunResult.setThrowable(eventresult.getError());
                        ResultUpdator.updateResult((TestCaseRunResult)testCaseRunResult);
                    } else {
                        logger.warn((Object)"QAFCucumberPlugin is unable to deploy result");
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"QAFCucumberPlugin is unable to deploy result", (Throwable)e);
            }
        }
    };
    private EventHandler<TestRunStarted> runStartedHandler = new EventHandler<TestRunStarted>(){

        public void receive(TestRunStarted event) {
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            this.endReport(event);
        }

        private void endReport(TestRunFinished event) {
            if (!ConfigurationManager.getBundle().getBoolean("usingtestngrunner", false)) {
                TestBaseProvider.instance().stopAll();
                ResultUpdator.awaitTermination();
            }
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        this.setCucumberRunner(true);
        publisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.tcStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.tcfinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepfinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
        publisher.registerHandlerFor(WriteEvent.class, event -> Reporter.log((String)event.getText()));
    }

    private boolean isDryRun(TestCase tc) {
        return (Boolean)QAFCucumberPlugin.getField("dryRun", tc);
    }

    public static BDD2PickleWrapper getBdd2Pickle(Object testCase) {
        try {
            if (testCase instanceof BDD2PickleWrapper) {
                return (BDD2PickleWrapper)testCase;
            }
            Object pickle = QAFCucumberPlugin.getField("pickle", testCase);
            if (pickle instanceof BDD2PickleWrapper) {
                return (BDD2PickleWrapper)pickle;
            }
            return QAFCucumberPlugin.getBdd2Pickle(pickle);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getField(String fieldName, Object classObj) {
        try {
            return FieldUtils.readField((Object)classObj, (String)fieldName, (boolean)true);
        }
        catch (Exception e1) {
            try {
                Field field = null;
                try {
                    field = classObj.getClass().getField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    Field[] fields;
                    for (Field f : fields = ClassUtil.getAllFields(classObj.getClass(), Object.class)) {
                        if (!f.getName().equalsIgnoreCase(fieldName)) continue;
                        field = f;
                        break;
                    }
                }
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                return field.get(classObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private void setCucumberRunner(boolean cucumberRunner) {
        ConfigurationManager.getBundle().setProperty("cucumber.run.mode", (Object)cucumberRunner);
    }
}

