/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2PickleWrapper;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.testng.report.ClassInfo;
import com.qmetry.qaf.automation.testng.report.MetaInfo;
import com.qmetry.qaf.automation.testng.report.MethodInfo;
import com.qmetry.qaf.automation.testng.report.MethodResult;
import com.qmetry.qaf.automation.testng.report.Report;
import com.qmetry.qaf.automation.testng.report.ReportEntry;
import com.qmetry.qaf.automation.testng.report.ReporterUtil;
import com.qmetry.qaf.automation.testng.report.TestOverview;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class QAFReporter {
    private static final Log logger = LogFactoryImpl.getLog(ReporterUtil.class);
    private static final String QAF_TEST_IDENTIFIER = "qaf_test_identifier";
    private static AtomicInteger passCnt = new AtomicInteger(0);
    private static AtomicInteger failCnt = new AtomicInteger(0);
    private static AtomicInteger skipCnt = new AtomicInteger(0);
    private static AtomicInteger indexer = new AtomicInteger(0);
    public static final String SUITENAME = ConfigurationManager.getBundle().getString("suite.name", new File(".").getAbsoluteFile().getParentFile().getName());

    public static void updateMetaInfo() {
        QAFReporter.createMetaInfo(false);
    }

    public static void createMetaInfo() {
        QAFReporter.createMetaInfo(true);
        QAFReporter.updateOverview(null, true);
    }

    private static void createMetaInfo(boolean listEntry) {
        HashSet<String> testNames = new HashSet<String>();
        testNames.add(QAFReporter.getTestName());
        String dir = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0]);
        Report report = new Report();
        if (!ConfigurationManager.getBundle().containsKey("suit.start.ts")) {
            dir = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[]{ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}) + "/" + DateUtil.getDate((int)0, (String[])new String[]{"EdMMMyy_hhmmssa"})});
            ConfigurationManager.getBundle().setProperty(ApplicationProperties.JSON_REPORT_DIR.key, (Object)dir);
            FileUtil.checkCreateDir((String)ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}));
            FileUtil.checkCreateDir((String)dir);
            ConfigurationManager.getBundle().setProperty("suit.start.ts", (Object)System.currentTimeMillis());
        } else {
            report.setEndTime(System.currentTimeMillis());
        }
        report.setName(SUITENAME);
        report.setTests(testNames);
        report.setDir(dir);
        int pass = passCnt.get();
        int fail = failCnt.get();
        int skip = skipCnt.get();
        int total = 0;
        report.setPass(pass);
        report.setFail(fail);
        report.setSkip(skip);
        report.setTotal(pass + fail + skip > total ? pass + fail + skip : total);
        report.setStatus(fail > 0 ? "fail" : (pass > 0 ? "pass" : "unstable"));
        report.setStartTime(Long.valueOf(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L)));
        QAFReporter.appendReportInfo(report);
        if (listEntry) {
            ReportEntry reportEntry = new ReportEntry();
            reportEntry.setName(SUITENAME);
            reportEntry.setStartTime(Long.valueOf(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L)));
            reportEntry.setDir(dir);
            QAFReporter.appendMetaInfo(reportEntry);
        }
    }

    public static synchronized void updateOverview(String classname, boolean evnEntry) {
        try {
            int skip;
            int fail;
            int pass;
            int total;
            String file = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0]) + "/" + QAFReporter.getTestName() + "/overview.json";
            TestOverview overview = (TestOverview)JSONUtil.getJsonObjectFromFile((String)file, TestOverview.class);
            if (evnEntry) {
                HashMap<String, String> runPrams = new HashMap<String, String>();
                Configuration env = ConfigurationManager.getBundle().subset("env");
                Iterator iter = env.getKeys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    runPrams.put(key, env.getString(key));
                }
                HashMap<String, Object> envInfo = new HashMap<String, Object>();
                envInfo.put("isfw-build-info", ConfigurationManager.getBundle().getObject("isfw.build.info"));
                envInfo.put("run-parameters", runPrams);
                envInfo.put("browser-desired-capabilities", ConfigurationManager.getBundle().getObject("driver.desiredCapabilities"));
                envInfo.put("browser-actual-capabilities", QAFReporter.getActualCapabilities());
                overview.setEnvInfo(envInfo);
                HashMap<String, String> executionEnvInfo = new HashMap<String, String>();
                executionEnvInfo.put("os.name", System.getProperty("os.name"));
                executionEnvInfo.put("os.version", System.getProperty("os.version"));
                executionEnvInfo.put("os.arch", System.getProperty("os.arch"));
                executionEnvInfo.put("java.version", System.getProperty("java.version"));
                executionEnvInfo.put("java.vendor", System.getProperty("java.vendor"));
                executionEnvInfo.put("java.arch", System.getProperty("sun.arch.data.model"));
                executionEnvInfo.put("user.name", System.getProperty("user.name"));
                executionEnvInfo.put("host", System.getProperty("host.name"));
                envInfo.put("execution-env-info", executionEnvInfo);
            }
            overview.setTotal((total = (pass = passCnt.get()) + (fail = failCnt.get()) + (skip = skipCnt.get())) > pass + fail + skip ? total : pass + fail + skip);
            overview.setPass(pass);
            overview.setSkip(skip);
            overview.setFail(fail);
            if (null != classname) {
                overview.getClasses().add(classname);
            }
            if (overview.getStartTime() > 0L) {
                overview.setEndTime(Long.valueOf(System.currentTimeMillis()));
            } else {
                overview.setStartTime(Long.valueOf(System.currentTimeMillis()));
            }
            JSONUtil.writeJsonObjectToFile((String)file, (Object)overview);
            QAFReporter.updateMetaInfo();
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    private static Map<String, String> getActualCapabilities() {
        Map map = (Map)ConfigurationManager.getBundle().getObject("driver.actualCapabilities");
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (null != map) {
            for (String key : map.keySet()) {
                try {
                    newMap.put(key, String.valueOf(map.get(key)));
                }
                catch (Exception exception) {}
            }
        }
        return newMap;
    }

    public static void createMethodResult(String className, BDD2PickleWrapper bdd2Pickle, long durationMs, String result, Throwable error, List<LoggingBean> logs, List<CheckpointResultBean> checkpoints) {
        try {
            String classdir = QAFReporter.getClassDir(QAFReporter.getTestName() + "/" + className);
            MethodResult methodResult = new MethodResult();
            methodResult.setSeleniumLog(logs);
            methodResult.setCheckPoints(checkpoints);
            methodResult.setThrowable(error);
            String fileName = QAFReporter.getMethodIdentifier(bdd2Pickle);
            String methodResultFile = classdir + "/" + fileName;
            File f = new File(methodResultFile + ".json");
            bdd2Pickle.getMetaData().remove(QAF_TEST_IDENTIFIER);
            if (f.exists()) {
                String suffix = "_" + indexer.incrementAndGet();
                fileName = fileName + suffix;
                methodResultFile = classdir + "/" + fileName;
                QAFReporter.updateClassMetaInfo(bdd2Pickle, durationMs, result, fileName, className);
            } else {
                QAFReporter.updateClassMetaInfo(bdd2Pickle, durationMs, result, fileName, className);
            }
            JSONUtil.writeJsonObjectToFile((String)(methodResultFile + ".json"), (Object)methodResult);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static synchronized void updateClassMetaInfo(BDD2PickleWrapper bdd2Pickle, long durationMs, String result, String methodfname, String classname) {
        String dir = QAFReporter.getClassDir(QAFReporter.getTestName() + "/" + classname);
        String file = dir + "/meta-info.json";
        FileUtil.checkCreateDir((String)dir);
        ClassInfo classInfo = (ClassInfo)JSONUtil.getJsonObjectFromFile((String)file, ClassInfo.class);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setStartTime(System.currentTimeMillis() - durationMs);
        methodInfo.setDuration(durationMs);
        Map<String, Object> metadata = bdd2Pickle.getMetaData();
        if (null != bdd2Pickle.getTestData()) {
            methodInfo.setArgs(new Object[]{bdd2Pickle.getTestData()});
        }
        methodInfo.setMetaData(metadata);
        methodInfo.setType("test");
        methodInfo.setResult(QAFReporter.getResult(result));
        if (StringUtil.isNotBlank((String)methodfname)) {
            metadata.put("resultFileName", methodfname);
        }
        QAFReporter.updateOverview(classname, false);
        if (!classInfo.getMethods().contains(methodInfo)) {
            logger.debug((Object)("method:  result: " + methodInfo.getResult() + " groups: " + methodInfo.getMetaData()));
            classInfo.getMethods().add(methodInfo);
            JSONUtil.writeJsonObjectToFile((String)file, (Object)classInfo);
        } else {
            logger.warn((Object)("methodInfo already wrritten for " + methodInfo.getName()));
        }
    }

    private static String getMethodName(BDD2PickleWrapper bdd2Pickle) {
        return bdd2Pickle.getName();
    }

    private static String getMethodIdentifier(BDD2PickleWrapper bdd2Pickle) {
        String idFromMetaData;
        String id = QAFReporter.getMethodName(bdd2Pickle);
        String identifierKey = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal(new String[]{"testCaseId"});
        TreeMap<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        metadata.putAll(bdd2Pickle.getMetaData());
        if (bdd2Pickle.getTestData() != null) {
            metadata.putAll(bdd2Pickle.getTestData());
        }
        if (StringUtil.isNotBlank((String)(idFromMetaData = metadata.getOrDefault(identifierKey, "").toString()))) {
            id = idFromMetaData;
        }
        if ((id = StringUtil.toTitleCaseIdentifier((String)id)).length() > 45) {
            id = id.substring(0, 45);
        }
        bdd2Pickle.getMetaData().put(QAF_TEST_IDENTIFIER, id);
        return (String)bdd2Pickle.getMetaData().get(QAF_TEST_IDENTIFIER);
    }

    private static String getClassDir(String dir) {
        return ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[]{"test-results"}) + "/" + dir;
    }

    private static void appendReportInfo(Report report) {
        String file = report.getDir() + "/meta-info.json";
        JSONUtil.writeJsonObjectToFile((String)file, (Object)report);
    }

    private static void appendMetaInfo(ReportEntry report) {
        String file = ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}) + "/meta-info.json";
        MetaInfo metaInfo = (MetaInfo)JSONUtil.getJsonObjectFromFile((String)file, MetaInfo.class);
        metaInfo.getReports().remove(report);
        metaInfo.getReports().add(report);
        JSONUtil.writeJsonObjectToFile((String)file, (Object)metaInfo);
    }

    private static String getResult(String result) {
        switch (result.toUpperCase().charAt(0)) {
            case 'P': {
                passCnt.incrementAndGet();
                return "pass";
            }
            case 'F': {
                failCnt.incrementAndGet();
                return "fail";
            }
        }
        skipCnt.incrementAndGet();
        return "skip";
    }

    private static String getTestName() {
        return ConfigurationManager.getBundle().getString("testname", "BDD2");
    }
}

