/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.step.DefaultObjectFactory;
import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.backend.TypeResolver;
import io.cucumber.datatable.DataTable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class QAFStepDefinition
implements StepDefinition {
    TestStep step;
    Lookup lookup;
    String pattern;

    public QAFStepDefinition(TestStep step, Lookup lookup) {
        this.step = step instanceof JavaStep ? new JavaStepWarapper((JavaStep)step, lookup) : step;
        this.lookup = lookup;
        this.pattern = this.getPattern(step.getDescription());
    }

    public boolean isDefinedAt(StackTraceElement e) {
        if (this.step instanceof JavaStep) {
            Method method = ((JavaStep)this.step).getMethod();
            return e.getClassName().equals(method.getDeclaringClass().getName()) && e.getMethodName().equals(method.getName());
        }
        return false;
    }

    public String getLocation() {
        return this.step.getSignature();
    }

    public void execute(Object[] args) throws CucumberBackendException, CucumberInvocationTargetException {
        this.processArgs(args);
        this.step.setActualArgs(args);
        this.step.execute();
    }

    public List<ParameterInfo> parameterInfos() {
        ArrayList<ParameterInfo> parameterInfos = new ArrayList<ParameterInfo>();
        if (this.step instanceof JavaStep) {
            for (Parameter param : ((JavaStep)this.step).getMethod().getParameters()) {
                parameterInfos.add(new ParameterInfoImpl(param.getType()));
            }
        }
        return parameterInfos;
    }

    public String getPattern() {
        return this.pattern;
    }

    private String getPattern(String desce) {
        Parameter[] types;
        String pattern = this.step.getDescription().replaceAll(BDDDefinitionHelper.ParamType.getParamDefRegx(), "{string}");
        if (pattern.endsWith(":{string}") && this.step instanceof JavaStep && !(types = ((JavaStep)this.step).getMethod().getParameters())[types.length - 1].getType().isPrimitive()) {
            return pattern.substring(0, pattern.lastIndexOf("{string}"));
        }
        return pattern;
    }

    private void processArgs(Object[] args) {
        if (this.step instanceof JavaStep) {
            Parameter[] params = ((JavaStep)this.step).getMethod().getParameters();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof DataTable) || params[i].getType().isAssignableFrom(DataTable.class)) continue;
                DataTable table = (DataTable)arg;
                args[i] = this.convertDataTableObject(table, params[i]);
            }
        }
    }

    String convertDataTableObject(DataTable d, Parameter param) {
        List maps = d.transpose().asMaps();
        if (List.class.isAssignableFrom(param.getType())) {
            String ptype = param.getParameterizedType().getTypeName();
            if (ptype.contains("<Map") || ptype.contains("<List") || ((Map)maps.get(0)).keySet().size() > 1) {
                if (ptype.contains("<List")) {
                    return JSONObject.valueToString((Object)d.transpose().asLists());
                }
                return JSONObject.valueToString((Object)maps);
            }
            return JSONObject.valueToString((Object)d.transpose().asList());
        }
        if (param.isVarArgs() || param.getType().isArray()) {
            if (((Map)maps.get(0)).keySet().size() == 1 && param.getType().getComponentType().isPrimitive()) {
                return JSONObject.valueToString((Object)d.transpose().asList());
            }
            return JSONObject.valueToString((Object)maps);
        }
        if (maps.size() == 1) {
            return JSONObject.valueToString(maps.get(0));
        }
        return JSONObject.valueToString((Object)maps);
    }

    private class JavaStepWarapper
    extends JavaStep {
        Lookup lookup;

        public JavaStepWarapper(JavaStep step, Lookup lookup) {
            super(step.getMethod(), step.getName(), step.getDescription());
        }

        protected Object getStepProvider() throws Exception {
            Class<?> cls = this.method.getDeclaringClass();
            try {
                return this.lookup.getInstance(cls);
            }
            catch (Exception e) {
                try {
                    this.logger.debug((Object)("Unable to crete obect of class[" + cls + "] using [" + this.lookup.getClass() + "]. Using default qaf obect factory as fallback"));
                    return super.getStepProvider();
                }
                catch (Exception e1) {
                    return new DefaultObjectFactory().getObject(cls);
                }
            }
        }
    }

    class ParameterInfoImpl
    implements ParameterInfo {
        Type type;

        public ParameterInfoImpl(Type type) {
            this.type = type;
        }

        public Type getType() {
            if (this.type instanceof Class && ((Class)this.type).isPrimitive()) {
                return this.type;
            }
            return Object.class;
        }

        public boolean isTransposed() {
            return true;
        }

        public TypeResolver getTypeResolver() {
            return () -> this.getType();
        }
    }
}

