/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.bdd2.model;

import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2Location;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2Scenario;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2ScenarioOutline;
import gherkin.ast.GherkinDocument;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Located;
import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.Node;
import io.cucumber.core.gherkin.Pickle;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BDD2Feature
implements Feature {
    private final URI uri;
    private final List<Pickle> pickles;
    private final GherkinDocument gherkinDocument;
    private final List<Node> children;
    private final String bdd2Source;
    private Location location;

    public BDD2Feature(GherkinDocument gherkinDocument, URI uri, String bdd2Source, List<Pickle> pickles) {
        this.uri = uri;
        this.gherkinDocument = gherkinDocument;
        this.bdd2Source = bdd2Source;
        this.pickles = pickles;
        this.location = BDD2Location.from(gherkinDocument.getFeature().getLocation());
        this.children = gherkinDocument.getFeature().getChildren().stream().map(scenarioDefinition -> {
            if (scenarioDefinition instanceof ScenarioOutline) {
                return new BDD2ScenarioOutline((ScenarioDefinition)scenarioDefinition);
            }
            return new BDD2Scenario((ScenarioDefinition)scenarioDefinition);
        }).map(Node.class::cast).collect(Collectors.toList());
    }

    public Collection<Node> children() {
        return this.children;
    }

    public String getKeyword() {
        return this.gherkinDocument.getFeature().getKeyword();
    }

    public Optional<Pickle> getPickleAt(Located located) {
        Location location = located.getLocation();
        return this.pickles.stream().filter(cucumberPickle -> cucumberPickle.getLocation().equals(location)).findFirst();
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Pickle> getPickles() {
        return this.pickles;
    }

    public String getKeyWord() {
        return null;
    }

    public String getName() {
        return this.gherkinDocument.getFeature().getName();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.bdd2Source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BDD2Feature other = (BDD2Feature)o;
        return this.uri.equals(other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }
}

