/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.bdd2.model;

import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2Location;
import com.qmetry.qaf.automation.cucumber.bdd2.model.Bdd2Step;
import com.qmetry.qaf.automation.cucumber.bdd2.parser.Bdd2Pickle;
import gherkin.GherkinDialect;
import gherkin.ast.GherkinDocument;
import gherkin.ast.ScenarioDefinition;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleTag;
import io.cucumber.core.gherkin.Location;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BDD2PickleWrapper
implements Pickle {
    private final gherkin.pickles.Pickle pickle;
    private final List<Step> steps;
    private final URI uri;
    private final String keyWord;
    private final String id;

    public BDD2PickleWrapper(gherkin.pickles.Pickle pickle, URI uri, GherkinDocument document, GherkinDialect dialect) {
        this.pickle = pickle;
        this.uri = uri;
        this.steps = BDD2PickleWrapper.createCucumberSteps(pickle, document, dialect, uri.toString());
        this.keyWord = document.getFeature().getChildren().stream().filter(scenarioDefinition -> scenarioDefinition.getLocation().getLine() == this.getScenarioLocation().getLine()).map(ScenarioDefinition::getKeyword).findFirst().orElse("Scenario");
        this.id = pickle.getName() + ":" + pickle.getLocations().stream().map(l -> String.valueOf(l.getLine())).collect(Collectors.joining(":"));
    }

    private static List<Step> createCucumberSteps(gherkin.pickles.Pickle pickle, GherkinDocument document, GherkinDialect dialect, String uri) {
        ArrayList<Step> list = new ArrayList<Step>();
        String previousGivenWhenThen = dialect.getGivenKeywords().stream().filter(s -> !StepType.isAstrix((String)s)).findFirst().orElseThrow(() -> new IllegalStateException("No Given keyword for dialect: " + dialect.getName()));
        for (PickleStep step : pickle.getSteps()) {
            Bdd2Step cucumberStep = new Bdd2Step(step, document, dialect, previousGivenWhenThen, uri);
            if (cucumberStep.getType().isGivenWhenThen()) {
                previousGivenWhenThen = cucumberStep.getKeyWord();
            }
            list.add(cucumberStep);
        }
        return list;
    }

    public String getKeyword() {
        return this.keyWord;
    }

    public String getLanguage() {
        return this.pickle.getLanguage();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public Location getLocation() {
        return BDD2Location.from((PickleLocation)this.pickle.getLocations().get(0));
    }

    public Location getScenarioLocation() {
        int last = this.pickle.getLocations().size() - 1;
        return BDD2Location.from((PickleLocation)this.pickle.getLocations().get(last));
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<String> getTags() {
        return this.pickle.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BDD2PickleWrapper other = (BDD2PickleWrapper)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Map<String, Object> getTestData() {
        return ((Bdd2Pickle)this.pickle).getTestData();
    }

    public Map<String, Object> getMetaData() {
        return ((Bdd2Pickle)this.pickle).getMetaData();
    }

    public void setMetaData(Map<String, Object> metadata) {
        ((Bdd2Pickle)this.pickle).setMetaData(metadata);
    }
}

