/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.bdd2.model;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2DataTableArgument;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2DocStringArgument;
import gherkin.GherkinDialect;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import io.cucumber.core.gherkin.Argument;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import java.util.stream.Collectors;

public class Bdd2Step
implements Step {
    private final PickleStep step;
    private final Argument argument;
    private final String keyWord;
    private final StepType stepType;
    private final String previousGwtKeyWord;
    private final String uri;

    Bdd2Step(PickleStep step, GherkinDocument document, GherkinDialect dialect, String previousGwtKeyWord, String uri) {
        this.step = step;
        this.argument = this.extractArgument(step);
        this.keyWord = this.extractKeyWord(document);
        this.stepType = this.extractKeyWordType(this.keyWord, dialect);
        this.previousGwtKeyWord = previousGwtKeyWord;
        this.uri = uri;
    }

    private String extractKeyWord(GherkinDocument document) {
        return document.getFeature().getChildren().stream().flatMap(scenarioDefinition -> scenarioDefinition.getSteps().stream()).filter(step -> step.getLocation().getLine() == this.getLine()).findFirst().map(gherkin.ast.Step::getKeyword).orElseThrow(() -> new IllegalStateException("GherkinDocument did not contain PickleStep"));
    }

    private StepType extractKeyWordType(String keyWord, GherkinDialect dialect) {
        if (StepType.isAstrix((String)keyWord)) {
            return StepType.OTHER;
        }
        if (dialect.getGivenKeywords().contains(keyWord)) {
            return StepType.GIVEN;
        }
        if (dialect.getWhenKeywords().contains(keyWord)) {
            return StepType.WHEN;
        }
        if (dialect.getThenKeywords().contains(keyWord)) {
            return StepType.THEN;
        }
        if (dialect.getAndKeywords().contains(keyWord)) {
            return StepType.AND;
        }
        if (dialect.getButKeywords().contains(keyWord)) {
            return StepType.BUT;
        }
        throw new IllegalStateException("Keyword " + keyWord + " was neither given, when, then, and, but nor *");
    }

    private Argument extractArgument(PickleStep pickleStep) {
        if (pickleStep.getArgument().isEmpty()) {
            return null;
        }
        gherkin.pickles.Argument argument = (gherkin.pickles.Argument)pickleStep.getArgument().get(0);
        if (argument instanceof PickleString) {
            PickleString docString = (PickleString)argument;
            return new BDD2DocStringArgument(docString);
        }
        if (argument instanceof PickleTable) {
            PickleTable table = (PickleTable)argument;
            return new BDD2DataTableArgument(table);
        }
        return null;
    }

    public int getLine() {
        int last = this.step.getLocations().size() - 1;
        return ((PickleLocation)this.step.getLocations().get(last)).getLine();
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public StepType getType() {
        return this.stepType;
    }

    public String getPreviousGivenWhenThenKeyWord() {
        return this.previousGwtKeyWord;
    }

    public String getText() {
        return this.resolve(this.step.getText());
    }

    public String getId() {
        String lineNumbers = this.step.getLocations().stream().map(s -> String.valueOf(s.getLine())).collect(Collectors.joining(":"));
        return this.uri + ":" + lineNumbers;
    }

    private String resolve(String s) {
        return ConfigurationManager.getBundle().getSubstitutor().replace(s);
    }
}

