/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.bdd2.parser;

import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2Feature;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2PickleWrapper;
import com.qmetry.qaf.automation.cucumber.bdd2.parser.Bdd2Compiler;
import gherkin.AstBuilder;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.Pickle;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BDD2FeatureParser
implements FeatureParser {
    private static Optional<Feature> parseBDD2(URI path, String source) {
        try {
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(source, (Parser.ITokenMatcher)matcher);
            if (gherkinDocument.getFeature() == null) {
                return Optional.empty();
            }
            List<io.cucumber.core.gherkin.Pickle> pickles = BDD2FeatureParser.compilePickles(gherkinDocument, path);
            if (pickles.isEmpty()) {
                return Optional.empty();
            }
            BDD2Feature feature = new BDD2Feature(gherkinDocument, path, source, pickles);
            return Optional.of(feature);
        }
        catch (ParserException e) {
            throw new FeatureParserException("Failed to parse resource at: " + path.toString(), (Throwable)e);
        }
    }

    private static List<io.cucumber.core.gherkin.Pickle> compilePickles(GherkinDocument document, URI path) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        String language = document.getFeature().getLanguage();
        GherkinDialect dialect = dialectProvider.getDialect(language, null);
        return new Bdd2Compiler().compile(document).stream().map(pickle -> new BDD2PickleWrapper((Pickle)pickle, path, document, dialect)).collect(Collectors.toList());
    }

    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        return BDD2FeatureParser.parseBDD2(path, source);
    }

    public String version() {
        return "BDD2";
    }
}

