/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.bdd2.parser;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.bdd2.parser.Bdd2Pickle;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.testng.dataprovider.QAFInetrceptableDataProvider;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import gherkin.SymbolCounter;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bdd2Compiler {
    public List<Pickle> compile(GherkinDocument gherkinDocument) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return pickles;
        }
        String language = feature.getLanguage();
        ArrayList<Tag> featureTags = new ArrayList<Tag>(feature.getTags());
        featureTags.add(new Tag(feature.getLocation(), "@Feature:" + feature.getName()));
        ArrayList<Step> backgroundSteps = new ArrayList();
        for (ScenarioDefinition scenarioDefinition : feature.getChildren()) {
            Map<String, Object> metadata;
            if (scenarioDefinition instanceof Background) {
                backgroundSteps = scenarioDefinition.getSteps();
                continue;
            }
            if (scenarioDefinition instanceof Scenario) {
                metadata = this.getMetaData(featureTags, ((Scenario)scenarioDefinition).getTags(), this.pickleLocation(scenarioDefinition.getLocation()));
                if (!MetaDataScanner.applyMetafilter(metadata)) continue;
                if (MetaDataScanner.hasDP(metadata)) {
                    ScenarioOutline outline = new ScenarioOutline(((Scenario)scenarioDefinition).getTags(), scenarioDefinition.getLocation(), scenarioDefinition.getKeyword(), scenarioDefinition.getName(), scenarioDefinition.getDescription(), scenarioDefinition.getSteps(), Collections.emptyList());
                    this.compileScenarioOutline(pickles, backgroundSteps, outline, featureTags, language, metadata);
                    continue;
                }
                this.compileScenario(pickles, backgroundSteps, (Scenario)scenarioDefinition, featureTags, language, metadata);
                continue;
            }
            metadata = this.getMetaData(featureTags, ((ScenarioOutline)scenarioDefinition).getTags(), this.pickleLocation(scenarioDefinition.getLocation()));
            if (!MetaDataScanner.applyMetafilter(metadata)) continue;
            this.compileScenarioOutline(pickles, backgroundSteps, (ScenarioOutline)scenarioDefinition, featureTags, language, metadata);
        }
        return pickles;
    }

    private void compileScenario(List<Pickle> pickles, List<Step> backgroundSteps, Scenario scenario, List<Tag> featureTags, String language, Map<String, Object> metadata) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            steps.addAll(this.pickleSteps(backgroundSteps));
        }
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(featureTags);
        scenarioTags.addAll(scenario.getTags());
        steps.addAll(this.pickleSteps(scenario.getSteps()));
        Bdd2Pickle pickle = new Bdd2Pickle(scenario.getName(), language, steps, this.pickleTags(scenarioTags), Collections.singletonList(this.pickleLocation(scenario.getLocation())), metadata);
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, List<Step> backgroundSteps, ScenarioOutline scenarioOutline, List<Tag> featureTags, String language, Map<String, Object> metadata) {
        ArrayList<Tag> scenariotags = new ArrayList<Tag>();
        scenariotags.addAll(featureTags);
        scenariotags.addAll(scenarioOutline.getTags());
        List<Examples> examplesToUse = this.getExamples(metadata, scenarioOutline);
        for (Examples examples : examplesToUse) {
            if (examples.getTableHeader() == null) continue;
            List variableCells = examples.getTableHeader().getCells();
            for (TableRow values : examples.getTableBody()) {
                List valueCells = values.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                if (!scenarioOutline.getSteps().isEmpty()) {
                    steps.addAll(this.pickleSteps(backgroundSteps, variableCells, valueCells, this.pickleLocation(values.getLocation())));
                }
                steps.addAll(this.pickleSteps(scenarioOutline.getSteps(), variableCells, valueCells, this.pickleLocation(values.getLocation())));
                ArrayList<Tag> tags = new ArrayList<Tag>(scenariotags);
                tags.addAll(examples.getTags());
                Bdd2Pickle pickle = new Bdd2Pickle(this.interpolate(scenarioOutline.getName(), variableCells, valueCells), language, steps, this.pickleTags(tags), Arrays.asList(this.pickleLocation(values.getLocation()), this.pickleLocation(scenarioOutline.getLocation())), examples.getTableHeader().getCells(), valueCells, this.getMetaData(metadata, examples.getTags()));
                pickles.add(pickle);
            }
        }
    }

    private List<Examples> getExamples(Map<String, Object> metadata, ScenarioOutline scenarioOutline) {
        if (null == metadata || !MetaDataScanner.hasDP(metadata)) {
            return scenarioOutline.getExamples();
        }
        ArrayList<Examples> listToReturn = new ArrayList<Examples>();
        List externalData = null;
        Location location = scenarioOutline.getLocation();
        try {
            externalData = Arrays.asList(QAFInetrceptableDataProvider.getData(metadata));
        }
        catch (Exception e) {
            if ("No data provider found".equalsIgnoreCase(e.getMessage())) {
                return scenarioOutline.getExamples();
            }
            throw new AutomationError(e.getMessage() + ":" + scenarioOutline.getName());
        }
        if (null == externalData) {
            return scenarioOutline.getExamples();
        }
        TableRow tableHeader = new TableRow(location, ((Map)((Object[])externalData.get(0))[0]).keySet().stream().map(key -> new TableCell(location, key)).collect(Collectors.toList()));
        List tableBody = externalData.stream().map(o -> new TableRow(location, ((Map)o[0]).values().stream().map(val -> new TableCell(location, this.toString(val))).collect(Collectors.toList()))).collect(Collectors.toList());
        listToReturn.add(new Examples(location, new ArrayList(), null, null, null, tableHeader, tableBody));
        try {
            ClassUtil.setField((String)"examples", (Object)scenarioOutline, listToReturn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return listToReturn;
    }

    private List<Argument> createPickleArguments(Node argument) {
        List<TableCell> noCells = Collections.emptyList();
        return this.createPickleArguments(argument, noCells, noCells);
    }

    private List<Argument> createPickleArguments(Node argument, List<TableCell> variableCells, List<TableCell> valueCells) {
        ArrayList<Argument> result = new ArrayList<Argument>();
        if (argument == null) {
            return result;
        }
        if (argument instanceof DataTable) {
            DataTable t = (DataTable)argument;
            List rows = t.getRows();
            ArrayList<PickleRow> newRows = new ArrayList<PickleRow>(rows.size());
            for (TableRow row : rows) {
                List cells = row.getCells();
                ArrayList<PickleCell> newCells = new ArrayList<PickleCell>();
                for (TableCell cell : cells) {
                    newCells.add(new PickleCell(this.pickleLocation(cell.getLocation()), this.interpolate(cell.getValue(), variableCells, valueCells)));
                }
                newRows.add(new PickleRow(newCells));
            }
            result.add((Argument)new PickleTable(newRows));
        } else if (argument instanceof DocString) {
            DocString ds = (DocString)argument;
            result.add((Argument)new PickleString(this.pickleLocation(ds.getLocation()), this.interpolate(ds.getContent(), variableCells, valueCells), ds.getContentType() == null ? null : this.interpolate(ds.getContentType(), variableCells, valueCells)));
        } else {
            throw new RuntimeException("Unexpected argument type: " + argument);
        }
        return result;
    }

    private List<PickleStep> pickleSteps(List<Step> scenarioDefinition, List<TableCell> variableCells, List<TableCell> valueCells, PickleLocation location) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        for (Step step : scenarioDefinition) {
            String stepText = this.interpolate(step.getText(), variableCells, valueCells);
            PickleStep pickleStep = new PickleStep(stepText, this.createPickleArguments(step.getArgument(), variableCells, valueCells), Arrays.asList(location, this.pickleStepLocation(step)));
            result.add(pickleStep);
        }
        return Collections.unmodifiableList(result);
    }

    private List<PickleStep> pickleSteps(List<Step> scenarioDefinition) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        for (Step step : scenarioDefinition) {
            result.add(this.pickleStep(step));
        }
        return Collections.unmodifiableList(result);
    }

    private PickleStep pickleStep(Step step) {
        return new PickleStep(step.getText(), this.createPickleArguments(step.getArgument()), Collections.singletonList(this.pickleStepLocation(step)));
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        HashMap<String, String> row = new HashMap<String, String>();
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
            name = name.replace("${" + header + "}", value);
            row.put(header, value);
        }
        name = name.replace("\"${args[0]}\"", JSONObject.quote((String)JSONObject.valueToString(row)));
        name = name.replace("${args[0]}", JSONObject.valueToString(row));
        return name;
    }

    private PickleLocation pickleStepLocation(Step step) {
        return new PickleLocation(step.getLocation().getLine(), step.getLocation().getColumn() + (step.getKeyword() != null ? SymbolCounter.countSymbols((String)step.getKeyword()) : 0));
    }

    private PickleLocation pickleLocation(Location location) {
        return new PickleLocation(location.getLine(), location.getColumn());
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(this.pickleLocation(tag.getLocation()), tag.getName());
    }

    private Map<String, Object> getMetaData(List<Tag> featureTags, List<Tag> tags, PickleLocation pickleLocation) {
        TreeMap<String, Object> metaData = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        metaData.put("line", pickleLocation.getLine());
        this.addMetaData(metaData, featureTags);
        this.addMetaData(metaData, tags);
        return metaData;
    }

    private void addMetaData(Map<String, Object> metaData, List<Tag> tags) {
        tags.stream().filter(tag -> tag.getName().contains(":")).forEach(tag -> {
            String[] kv = tag.getName().substring(1).split(":", 2);
            metaData.put(kv[0], JSONUtil.toObject((String)ConfigurationManager.getBundle().getSubstitutor().replace(kv[1])));
        });
        List groups = metaData.getOrDefault("groups", new ArrayList());
        tags.stream().filter(tag -> !tag.getName().contains(":")).forEach(tag -> groups.add(tag.getName().substring(1)));
        metaData.put("groups", groups);
    }

    private Map<String, Object> getMetaData(Map<String, Object> metaData, List<Tag> tags) {
        TreeMap<String, Object> metaDataToReturn = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        metaDataToReturn.putAll(metaData);
        this.addMetaData(metaDataToReturn, tags);
        return metaData;
    }

    private String toString(Object o) {
        if (o instanceof Map) {
            return JSONObject.valueToString((Object)o);
        }
        if (o instanceof Collections) {
            return new JSONArray(o).toString();
        }
        return String.valueOf(o);
    }
}

