/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.runner;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.QAFCucumberPlugin;
import com.qmetry.qaf.automation.cucumber.bdd2.model.BDD2PickleWrapper;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.Scenario;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runner.Runner;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import java.util.Collection;
import java.util.stream.Collectors;
import org.testng.ITestContext;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CucumberScenario
extends Scenario {
    private BDD2PickleWrapper bdd2pickle;
    private Runner runner;
    private final EventHandler<TestCaseFinished> testCaseFinished = this::handleTestCaseFinished;
    private Result result;

    public CucumberScenario(String testName, Pickle pickle, Runner runner) {
        super(testName, null, QAFCucumberPlugin.getBdd2Pickle(pickle).getMetaData());
        this.bdd2pickle = QAFCucumberPlugin.getBdd2Pickle(pickle);
        this.runner = runner;
        this.bdd2pickle.setMetaData(this.getMetadata());
    }

    @Test(groups={"scenario"})
    public void scenario() {
        this.beforeScanario();
        this.runner.runPickle((Pickle)this.bdd2pickle);
        this.afterScenario();
    }

    protected void beforeScanario() {
        super.beforeScanario();
        this.runner.getBus().registerHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    private void afterScenario() {
        this.runner.getBus().removeHandlerFor(TestCaseFinished.class, this.testCaseFinished);
        Status status = this.result.getStatus();
        if (!status.is(Status.PASSED)) {
            Throwable error = this.result.getError();
            try {
                if (status.is(Status.SKIPPED) && error != null) {
                    throw new AutomationError(error);
                }
                if (status.is(Status.SKIPPED) || status.is(Status.UNDEFINED)) {
                    throw new AutomationError(status.name());
                }
                if (status.is(Status.PENDING)) {
                    throw new AutomationError(status.name(), error);
                }
                if (null == error) {
                    throw new RuntimeException("Error=null while with status=" + this.result.getStatus());
                }
                throw error;
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Error r) {
                throw r;
            }
            catch (Throwable t) {
                new RuntimeException(error);
            }
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.result = event.getResult();
    }

    @BeforeTest(alwaysRun=true)
    public void setTestName(ITestContext context) {
        ConfigurationManager.getBundle().setProperty("usingtestngrunner", (Object)true);
        ConfigurationManager.getBundle().setProperty("testname", (Object)context.getCurrentXmlTest().getName());
    }

    @AfterTest(alwaysRun=true)
    public void testRunFinished(ITestContext context) {
        EventBus eventBus = (EventBus)context.getAttribute("eventBus");
        eventBus.send((Event)new TestRunFinished(eventBus.getInstant()));
    }

    public Collection<TestStep> getSteps() {
        return this.bdd2pickle.getSteps().stream().map(s -> new StringTestStep(s.getText(), new Object[0])).collect(Collectors.toList());
    }
}

