/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber.runner;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.QAFCucumberPlugin;
import com.qmetry.qaf.automation.cucumber.runner.CucumberScenario;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.exec.util.MapUtils;
import org.testng.ITestContext;
import org.testng.annotations.Factory;

public class CucumberScenarioFactory {
    @Factory
    public Object[] getTestsFromFile(ITestContext context) {
        ConfigurationManager.getBundle().setProperty("usingtestngrunner", (Object)true);
        context.getCurrentXmlTest().getLocalParameters().put("testname", context.getCurrentXmlTest().getName());
        ConfigurationManager.addAll((Map)context.getCurrentXmlTest().getAllParameters());
        TimeServiceEventBus eventBus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        context.setAttribute("eventBus", (Object)eventBus);
        if (!ConfigurationManager.getBundle().containsKey("eventBus")) {
            ConfigurationManager.getBundle().setProperty("eventBus", new ArrayList());
        }
        ((List)ConfigurationManager.getBundle().getProperty("eventBus")).add(eventBus);
        ConfigurationManager.getBundle().setProperty("suite.name", (Object)context.getCurrentXmlTest().getSuite().getName());
        if (StringUtil.isBlank((String)ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[]{""}))) {
            String dir = ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}) + "/" + DateUtil.getDate((int)0, (String[])new String[]{"EdMMMyy_hhmmssa"});
            ConfigurationManager.getBundle().setProperty(ApplicationProperties.JSON_REPORT_DIR.key, (Object)dir);
        }
        Properties source = ConfigurationConverter.getProperties((Configuration)ConfigurationManager.getBundle().subset("cucumber"));
        HashMap props = new HashMap(MapUtils.prefix((Map)source, (String)"cucumber"));
        RuntimeOptions runtimeOptions = new CucumberPropertiesParser().parse(props).build();
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(classLoader, (ObjectFactorySupplier)objectFactorySupplier);
        Plugins plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        ExitStatus exitStatus = new ExitStatus(runtimeOptions);
        plugins.addPlugin((Plugin)exitStatus);
        QAFCucumberPlugin qafCucumberPlugin = new QAFCucumberPlugin();
        if (plugins.getPlugins().stream().noneMatch(p -> p instanceof QAFCucumberPlugin)) {
            plugins.getPlugins().add(0, qafCucumberPlugin);
            System.out.println("Added QAFCucumberPlugin");
        }
        plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)eventBus);
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)runtimeOptions, (EventBus)eventBus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)eventBus).generateId());
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        Filters filter = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        List features = featureSupplier.get();
        for (Feature feature2 : features) {
            eventBus.send((Event)new TestSourceRead(eventBus.getInstant(), feature2.getUri(), feature2.getSource()));
        }
        List cucumberScenarios = features.stream().flatMap(feature -> feature.getPickles().stream()).filter(filter).map(arg_0 -> CucumberScenarioFactory.lambda$getTestsFromFile$2((RunnerSupplier)runnerSupplier, arg_0)).collect(Collectors.toList());
        return cucumberScenarios.toArray();
    }

    private static /* synthetic */ CucumberScenario lambda$getTestsFromFile$2(RunnerSupplier runnerSupplier, Pickle pickle) {
        return new CucumberScenario(pickle.getName(), pickle, runnerSupplier.get());
    }

    static final class ExitStatus
    implements ConcurrentEventListener {
        private static final byte DEFAULT = 0;
        private static final byte ERRORS = 1;
        private final List<Result> results = new ArrayList<Result>();
        private final RuntimeOptions runtimeOptions;
        private final EventHandler<TestCaseFinished> testCaseFinishedHandler = event -> this.results.add(event.getResult());

        ExitStatus(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
        }

        public void setEventPublisher(EventPublisher publisher) {
            publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        }

        byte exitStatus() {
            if (this.results.isEmpty()) {
                return 0;
            }
            if (this.runtimeOptions.isWip()) {
                Result leastSeverResult = Collections.min(this.results, Comparator.comparing(Result::getStatus));
                return leastSeverResult.getStatus().is(Status.PASSED) ? (byte)1 : 0;
            }
            Result mostSevereResult = Collections.max(this.results, Comparator.comparing(Result::getStatus));
            return mostSevereResult.getStatus().isOk(this.runtimeOptions.isStrict()) ? (byte)0 : 1;
        }
    }
}

