/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.Status;
import java.time.Duration;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Result {
    private Status status;
    private final Duration duration;
    private Throwable error;

    public Result(Status status, Duration duration, Throwable error) {
        this.status = Objects.requireNonNull(status);
        this.duration = Objects.requireNonNull(duration);
        this.error = error;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public String toString() {
        return "Result{status=" + this.status + ", duration=" + this.duration.getSeconds() + ", error=" + this.error + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.status == result.status && Objects.equals(this.duration, result.duration) && Objects.equals(this.error, result.error);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.duration, this.error);
    }
}

