/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.cucumber.Bdd2Pickle;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.testng.dataprovider.QAFInetrceptableDataProvider;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import gherkin.SymbolCounter;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class Bdd2Compiler {
    public List<Pickle> compile(GherkinDocument gherkinDocument) {
        ArrayList<Pickle> arrayList = new ArrayList<Pickle>();
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return arrayList;
        }
        String string = feature.getLanguage();
        List list = feature.getTags();
        ArrayList<PickleStep> arrayList2 = new ArrayList();
        for (ScenarioDefinition scenarioDefinition : feature.getChildren()) {
            Map<String, Object> map;
            if (scenarioDefinition instanceof Background) {
                arrayList2 = this.pickleSteps(scenarioDefinition);
                continue;
            }
            if (scenarioDefinition instanceof Scenario) {
                map = this.getMetaData(list, ((Scenario)scenarioDefinition).getTags(), this.pickleLocation(scenarioDefinition.getLocation()));
                if (!MetaDataScanner.applyMetafilter(map)) continue;
                if (MetaDataScanner.hasDP(map)) {
                    ScenarioOutline scenarioOutline = new ScenarioOutline(((Scenario)scenarioDefinition).getTags(), scenarioDefinition.getLocation(), scenarioDefinition.getKeyword(), scenarioDefinition.getName(), scenarioDefinition.getDescription(), scenarioDefinition.getSteps(), Collections.emptyList());
                    this.compileScenarioOutline(arrayList, arrayList2, scenarioOutline, list, string, map);
                    continue;
                }
                this.compileScenario(arrayList, arrayList2, (Scenario)scenarioDefinition, list, string, map);
                continue;
            }
            map = this.getMetaData(list, ((ScenarioOutline)scenarioDefinition).getTags(), this.pickleLocation(scenarioDefinition.getLocation()));
            if (!MetaDataScanner.applyMetafilter(map)) continue;
            this.compileScenarioOutline(arrayList, arrayList2, (ScenarioOutline)scenarioDefinition, list, string, map);
        }
        return arrayList;
    }

    private void compileScenario(List<Pickle> list, List<PickleStep> list2, Scenario scenario, List<Tag> list3, String string, Map<String, Object> map) {
        ArrayList<PickleStep> arrayList = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            arrayList.addAll(list2);
        }
        ArrayList<Tag> arrayList2 = new ArrayList<Tag>();
        arrayList2.addAll(list3);
        arrayList2.addAll(scenario.getTags());
        arrayList.addAll(this.pickleSteps((ScenarioDefinition)scenario));
        Bdd2Pickle bdd2Pickle = new Bdd2Pickle(scenario.getName(), string, arrayList, this.pickleTags(arrayList2), Collections.singletonList(this.pickleLocation(scenario.getLocation())), map);
        list.add(bdd2Pickle);
    }

    private void compileScenarioOutline(List<Pickle> list, List<PickleStep> list2, ScenarioOutline scenarioOutline, List<Tag> list3, String string, Map<String, Object> map) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        arrayList.addAll(list3);
        arrayList.addAll(scenarioOutline.getTags());
        List<Examples> list4 = this.getExamples(map, scenarioOutline);
        for (Examples examples : list4) {
            if (examples.getTableHeader() == null) continue;
            List list5 = examples.getTableHeader().getCells();
            for (TableRow tableRow : examples.getTableBody()) {
                Object object2;
                List list6 = tableRow.getCells();
                ArrayList<PickleStep> arrayList2 = new ArrayList<PickleStep>();
                if (!scenarioOutline.getSteps().isEmpty()) {
                    arrayList2.addAll(list2);
                }
                for (Object object2 : scenarioOutline.getSteps()) {
                    String string2 = this.interpolate(object2.getText(), list5, list6);
                    PickleStep pickleStep = new PickleStep(string2, this.createPickleArguments(object2.getArgument(), list5, list6), Arrays.asList(this.pickleLocation(tableRow.getLocation()), this.pickleStepLocation((Step)object2)));
                    arrayList2.add(pickleStep);
                }
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.addAll(examples.getTags());
                object2 = new Bdd2Pickle(this.interpolate(scenarioOutline.getName(), list5, list6), string, arrayList2, this.pickleTags(arrayList3), Arrays.asList(this.pickleLocation(tableRow.getLocation()), this.pickleLocation(scenarioOutline.getLocation())), examples.getTableHeader().getCells(), list6, this.getMetaData(map, examples.getTags()));
                list.add((Pickle)object2);
            }
        }
    }

    private List<Examples> getExamples(Map<String, Object> map, ScenarioOutline scenarioOutline) {
        if (null == map || !MetaDataScanner.hasDP(map)) {
            return scenarioOutline.getExamples();
        }
        ArrayList<Examples> arrayList = new ArrayList<Examples>();
        List list = null;
        Location location = scenarioOutline.getLocation();
        try {
            list = Arrays.asList(QAFInetrceptableDataProvider.getData(map));
        }
        catch (Exception exception) {
            if ("No data provider found".equalsIgnoreCase(exception.getMessage())) {
                return scenarioOutline.getExamples();
            }
            throw new AutomationError(exception.getMessage() + ":" + scenarioOutline.getName());
        }
        if (null == list) {
            return scenarioOutline.getExamples();
        }
        TableRow tableRow = new TableRow(location, ((Map)((Object[])list.get(0))[0]).keySet().stream().map(string -> new TableCell(location, string)).collect(Collectors.toList()));
        List list2 = list.stream().map(objectArray -> new TableRow(location, ((Map)objectArray[0]).values().stream().map(object -> new TableCell(location, object.toString())).collect(Collectors.toList()))).collect(Collectors.toList());
        arrayList.add(new Examples(location, new ArrayList(), null, null, null, tableRow, list2));
        ClassUtil.setField((String)"examples", (Object)scenarioOutline, arrayList);
        return arrayList;
    }

    private List<Argument> createPickleArguments(Node node) {
        List<TableCell> list = Collections.emptyList();
        return this.createPickleArguments(node, list, list);
    }

    private List<Argument> createPickleArguments(Node node, List<TableCell> list, List<TableCell> list2) {
        ArrayList<Argument> arrayList = new ArrayList<Argument>();
        if (node == null) {
            return arrayList;
        }
        if (node instanceof DataTable) {
            DataTable dataTable = (DataTable)node;
            List list3 = dataTable.getRows();
            ArrayList<PickleRow> arrayList2 = new ArrayList<PickleRow>(list3.size());
            for (TableRow tableRow : list3) {
                List list4 = tableRow.getCells();
                ArrayList<PickleCell> arrayList3 = new ArrayList<PickleCell>();
                for (TableCell tableCell : list4) {
                    arrayList3.add(new PickleCell(this.pickleLocation(tableCell.getLocation()), this.interpolate(tableCell.getValue(), list, list2)));
                }
                arrayList2.add(new PickleRow(arrayList3));
            }
            arrayList.add((Argument)new PickleTable(arrayList2));
        } else if (node instanceof DocString) {
            DocString docString = (DocString)node;
            arrayList.add((Argument)new PickleString(this.pickleLocation(docString.getLocation()), this.interpolate(docString.getContent(), list, list2), docString.getContentType() == null ? null : this.interpolate(docString.getContentType(), list, list2)));
        } else {
            throw new RuntimeException("Unexpected argument type: " + node);
        }
        return arrayList;
    }

    private List<PickleStep> pickleSteps(ScenarioDefinition scenarioDefinition) {
        ArrayList<PickleStep> arrayList = new ArrayList<PickleStep>();
        for (Step step : scenarioDefinition.getSteps()) {
            arrayList.add(this.pickleStep(step));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private PickleStep pickleStep(Step step) {
        return new PickleStep(step.getText(), this.createPickleArguments(step.getArgument()), Collections.singletonList(this.pickleStepLocation(step)));
    }

    private String interpolate(String string, List<TableCell> list, List<TableCell> list2) {
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TableCell tableCell : list) {
            TableCell tableCell2 = list2.get(n++);
            String string2 = tableCell.getValue();
            String string3 = tableCell2.getValue();
            string = string.replace("<" + string2 + ">", string3);
            string = string.replace("${" + string2 + "}", string3);
            hashMap.put(string2, string3);
        }
        string = string.replace("\"${args[0]}\"", JSONObject.quote((String)JSONObject.valueToString(hashMap)));
        string = string.replace("${args[0]}", JSONObject.valueToString(hashMap));
        return string;
    }

    private PickleLocation pickleStepLocation(Step step) {
        return new PickleLocation(step.getLocation().getLine(), step.getLocation().getColumn() + (step.getKeyword() != null ? SymbolCounter.countSymbols((String)step.getKeyword()) : 0));
    }

    private PickleLocation pickleLocation(Location location) {
        return new PickleLocation(location.getLine(), location.getColumn());
    }

    private List<PickleTag> pickleTags(List<Tag> list) {
        ArrayList<PickleTag> arrayList = new ArrayList<PickleTag>();
        for (Tag tag : list) {
            arrayList.add(this.pickleTag(tag));
        }
        return arrayList;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(this.pickleLocation(tag.getLocation()), tag.getName());
    }

    private Map<String, Object> getMetaData(List<Tag> list, List<Tag> list2, PickleLocation pickleLocation) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        treeMap.put("line", pickleLocation.getLine());
        this.addMetaData(treeMap, list);
        this.addMetaData(treeMap, list2);
        return treeMap;
    }

    private void addMetaData(Map<String, Object> map, List<Tag> list) {
        list.stream().filter(tag -> tag.getName().contains(":")).forEach(tag -> {
            String[] stringArray = tag.getName().substring(1).split(":", 2);
            map.put(stringArray[0], StringUtil.toObject((String)ConfigurationManager.getBundle().getSubstitutor().replace(stringArray[1])));
        });
        List list2 = map.getOrDefault("groups", new ArrayList());
        list.stream().filter(tag -> !tag.getName().contains(":")).forEach(tag -> list2.add(tag.getName().substring(1)));
        map.put("groups", list2);
    }

    private Map<String, Object> getMetaData(Map<String, Object> map, List<Tag> list) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(map);
        this.addMetaData(treeMap, list);
        return map;
    }
}

