/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.cucumber.Bdd2Pickle;
import com.qmetry.qaf.automation.cucumber.QAFReporter;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.Reporter;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class QAFCucumberPlugin
implements ConcurrentEventListener {
    private static final Log logger = LogFactoryImpl.getLog(QAFCucumberPlugin.class);
    private EventHandler<EmbedEvent> embedEventHandler = new EventHandler<EmbedEvent>(){

        public void receive(EmbedEvent embedEvent) {
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted testStepStarted) {
            QAFTestBase qAFTestBase = (QAFTestBase)TestBaseProvider.instance().get();
            ArrayList arrayList = new ArrayList(qAFTestBase.getCheckPointResults());
            ArrayList arrayList2 = new ArrayList(qAFTestBase.getLog());
            qAFTestBase.getCheckPointResults().clear();
            qAFTestBase.getLog().clear();
            qAFTestBase.getContext().setProperty("allResults", arrayList);
            qAFTestBase.getContext().setProperty("allCommands", arrayList2);
        }
    };
    private EventHandler<TestStepFinished> stepfinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished testStepFinished) {
            if (testStepFinished.testStep instanceof PickleStepTestStep) {
                this.logStep((PickleStepTestStep)testStepFinished.testStep, testStepFinished);
            }
        }

        private void logStep(PickleStepTestStep pickleStepTestStep, TestStepFinished testStepFinished) {
            CheckpointResultBean checkpointResultBean;
            Result result = testStepFinished.result;
            String string = pickleStepTestStep.getStepText();
            Long l = result.getDuration();
            QAFTestBase qAFTestBase = (QAFTestBase)TestBaseProvider.instance().get();
            if (result.getError() != null) {
                checkpointResultBean = new CheckpointResultBean();
                checkpointResultBean.setMessage(result.getError().getMessage());
                checkpointResultBean.setType(MessageTypes.Fail);
                qAFTestBase.getCheckPointResults().add(checkpointResultBean);
            }
            if (result.getStatus().equals((Object)Result.Type.UNDEFINED)) {
                string = string + ": Not Found";
                qAFTestBase.addVerificationError(testStepFinished.testStep.getCodeLocation() + "TestStep implementation not found");
            }
            checkpointResultBean = result.getStatus().equals((Object)Result.Type.PASSED) && this.getStepMessageType(qAFTestBase.getCheckPointResults()).isFailure() ? MessageTypes.TestStepFail : this.getStepMessageType(result.getStatus(), QAFCucumberPlugin.this.isDryRun(testStepFinished.getTestCase()));
            LoggingBean loggingBean = new LoggingBean(pickleStepTestStep.getPattern(), pickleStepTestStep.getDefinitionArgument().stream().map(argument -> argument.getValue()).collect(Collectors.toList()).toArray(new String[0]), result.getStatus().name());
            loggingBean.setSubLogs(new ArrayList(qAFTestBase.getLog()));
            CheckpointResultBean checkpointResultBean2 = new CheckpointResultBean();
            checkpointResultBean2.setMessage(string);
            checkpointResultBean2.setSubCheckPoints(new ArrayList(qAFTestBase.getCheckPointResults()));
            checkpointResultBean2.setDuration(l.intValue());
            checkpointResultBean2.setType((MessageTypes)checkpointResultBean);
            ArrayList arrayList = (ArrayList)qAFTestBase.getContext().getObject("allResults");
            ArrayList arrayList2 = (ArrayList)qAFTestBase.getContext().getObject("allCommands");
            qAFTestBase.getContext().clearProperty("allResults");
            qAFTestBase.getContext().clearProperty("allCommands");
            arrayList.add(checkpointResultBean2);
            qAFTestBase.getCheckPointResults().clear();
            qAFTestBase.getCheckPointResults().addAll(arrayList);
            arrayList2.add(loggingBean);
            qAFTestBase.getLog().clear();
            qAFTestBase.getLog().addAll(arrayList2);
        }

        private MessageTypes getStepMessageType(List<CheckpointResultBean> list) {
            MessageTypes messageTypes = MessageTypes.TestStepPass;
            for (CheckpointResultBean checkpointResultBean : list) {
                messageTypes = MessageTypes.TestStepPass;
                if (StringMatcher.containsIgnoringCase((String)"fail").match(checkpointResultBean.getType())) {
                    return MessageTypes.TestStepFail;
                }
                if (!StringMatcher.containsIgnoringCase((String)"warn").match(checkpointResultBean.getType())) continue;
                messageTypes = MessageTypes.Warn;
            }
            return messageTypes;
        }

        private MessageTypes getStepMessageType(Result.Type type, boolean bl) {
            switch (type) {
                case PASSED: {
                    return MessageTypes.TestStepPass;
                }
                case FAILED: 
                case UNDEFINED: {
                    return MessageTypes.TestStepFail;
                }
                case AMBIGUOUS: {
                    return MessageTypes.Warn;
                }
            }
            if (bl) {
                return MessageTypes.TestStepPass;
            }
            return MessageTypes.TestStep;
        }
    };
    private EventHandler<TestCaseStarted> tcStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted testCaseStarted) {
            Bdd2Pickle bdd2Pickle = QAFCucumberPlugin.getBdd2Pickle(testCaseStarted.getTestCase());
            bdd2Pickle.getMetaData().put("Referece", testCaseStarted.getTestCase().getUri());
            QAFTestBase qAFTestBase = (QAFTestBase)TestBaseProvider.instance().get();
            qAFTestBase.getLog().clear();
            qAFTestBase.clearVerificationErrors();
            qAFTestBase.getCheckPointResults().clear();
        }
    };
    private EventHandler<TestCaseFinished> tcfinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished testCaseFinished) {
            try {
                String string;
                Object object;
                Cloneable cloneable;
                TestCase testCase = testCaseFinished.getTestCase();
                Bdd2Pickle bdd2Pickle = QAFCucumberPlugin.getBdd2Pickle(testCase);
                boolean bl = QAFCucumberPlugin.this.isDryRun(testCase);
                Result result = testCaseFinished.result;
                Throwable throwable = result.getError();
                QAFTestBase qAFTestBase = (QAFTestBase)TestBaseProvider.instance().get();
                if (bl) {
                    cloneable = new HashMap<String, Object>(bdd2Pickle.getMetaData());
                    if (null != bdd2Pickle.getTestData()) {
                        cloneable.putAll(bdd2Pickle.getTestData());
                    }
                    if (StringUtil.isNotBlank((String)(object = MetaDataScanner.applyMetaRule(cloneable)))) {
                        throwable = new AutomationError("Metadata rule failure:" + (String)object);
                        qAFTestBase.addVerificationError(throwable);
                    }
                }
                cloneable = new ArrayList(qAFTestBase.getCheckPointResults());
                object = new ArrayList(qAFTestBase.getLog());
                if (qAFTestBase.getVerificationErrors() > 0 && (result.getStatus().equals((Object)Result.Type.PASSED) || bl)) {
                    result = new Result(null != throwable ? result.getStatus() : Result.Type.FAILED, result.getDuration(), throwable);
                    try {
                        ClassUtil.setField((String)"result", (Object)testCaseFinished, (Object)result);
                    }
                    catch (Exception exception) {}
                } else if (bl && null == throwable) {
                    result = new Result(Result.Type.PASSED, result.getDuration(), throwable);
                    try {
                        ClassUtil.setField((String)"result", (Object)testCaseFinished, (Object)result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String string2 = testCase.getScenarioDesignation().substring(0, testCase.getScenarioDesignation().indexOf(".feature")).replaceAll("/", ".");
                QAFReporter.createMethodResult(string2, bdd2Pickle, result.getDuration(), result.getStatus().name(), result.getError(), (List<LoggingBean>)object, (List<CheckpointResultBean>)((Object)cloneable));
                if (!bl) {
                    this.deployResult(bdd2Pickle, testCase, result);
                }
                if ((string = ConfigurationManager.getBundle().getString("selenium.singletone", "")).toUpperCase().startsWith("M")) {
                    qAFTestBase.tearDown();
                }
            }
            catch (Exception exception) {
                logger.error((Object)"QAFCucumberPlugin unable to process TestCaseFinished event", (Throwable)exception);
            }
        }

        private void deployResult(Bdd2Pickle bdd2Pickle, TestCase testCase, Result result) {
            String string = ConfigurationManager.getBundle().getString("result.updator");
            try {
                if (StringUtil.isNotBlank((String)string)) {
                    Object object;
                    TestCaseRunResult testCaseRunResult = result.getStatus() == Result.Type.PASSED ? TestCaseRunResult.PASS : (result.getStatus() == Result.Type.FAILED ? TestCaseRunResult.FAIL : TestCaseRunResult.SKIPPED);
                    Class<?> clazz = Class.forName(string);
                    TestCaseResultUpdator testCaseResultUpdator = (TestCaseResultUpdator)clazz.newInstance();
                    TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                    treeMap.put("name", testCase.getName());
                    treeMap.put("duration", result.getDuration());
                    if (null != bdd2Pickle && null != bdd2Pickle.getMetaData()) {
                        treeMap.putAll(bdd2Pickle.getMetaData());
                        object = bdd2Pickle.getTestData();
                        if (object != null) {
                            treeMap.put("testdata", object);
                            String string2 = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal(new String[]{"testCaseId"});
                            if (object.containsKey(string2)) {
                                treeMap.put(string2, object.get(string2));
                            }
                        }
                    }
                    object = (QAFTestBase)TestBaseProvider.instance().get();
                    ResultUpdator.updateResult((TestCaseRunResult)testCaseRunResult, (String)(object.getHTMLFormattedLog() + object.getAssertionsLog()), (TestCaseResultUpdator)testCaseResultUpdator, treeMap);
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"QAFCucumberPlugin unable to deploy result", (Throwable)exception);
            }
        }
    };
    private EventHandler<TestRunStarted> runStartedHandler = new EventHandler<TestRunStarted>(){

        public void receive(TestRunStarted testRunStarted) {
            this.startReport(testRunStarted);
        }

        private void startReport(TestRunStarted testRunStarted) {
            QAFReporter.createMetaInfo();
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished testRunFinished) {
            this.endReport(testRunFinished);
        }

        private void endReport(TestRunFinished testRunFinished) {
            QAFReporter.updateMetaInfo();
            QAFReporter.updateOverview(null, true);
            TestBaseProvider.instance().stopAll();
            ResultUpdator.awaitTermination();
        }
    };

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.setCucumberRunner(true);
        eventPublisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        eventPublisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        eventPublisher.registerHandlerFor(TestCaseStarted.class, this.tcStartedHandler);
        eventPublisher.registerHandlerFor(TestCaseFinished.class, this.tcfinishedHandler);
        eventPublisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        eventPublisher.registerHandlerFor(TestStepFinished.class, this.stepfinishedHandler);
        eventPublisher.registerHandlerFor(EmbedEvent.class, this.embedEventHandler);
        eventPublisher.registerHandlerFor(WriteEvent.class, writeEvent -> Reporter.log((String)writeEvent.text));
    }

    private boolean isDryRun(TestCase testCase) {
        return (Boolean)QAFCucumberPlugin.getField("dryRun", testCase);
    }

    private static Bdd2Pickle getBdd2Pickle(Object object) {
        try {
            return (Bdd2Pickle)((Object)QAFCucumberPlugin.getField("pickle", QAFCucumberPlugin.getField("pickleEvent", object)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getField(String string, Object object) {
        try {
            Field field = null;
            try {
                field = object.getClass().getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Field[] fieldArray;
                for (Field field2 : fieldArray = ClassUtil.getAllFields(object.getClass(), Object.class)) {
                    if (!field2.getName().equalsIgnoreCase(string)) continue;
                    field = field2;
                    break;
                }
            }
            field.setAccessible(true);
            Field field3 = Field.class.getDeclaredField("modifiers");
            field3.setAccessible(true);
            field3.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            return field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setCucumberRunner(boolean bl) {
        ConfigurationManager.getBundle().setProperty("cucumber.run.mode", (Object)bl);
    }
}

