/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.cucumber;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.cucumber.Bdd2Pickle;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.testng.report.ClassInfo;
import com.qmetry.qaf.automation.testng.report.MetaInfo;
import com.qmetry.qaf.automation.testng.report.MethodInfo;
import com.qmetry.qaf.automation.testng.report.MethodResult;
import com.qmetry.qaf.automation.testng.report.Report;
import com.qmetry.qaf.automation.testng.report.ReportEntry;
import com.qmetry.qaf.automation.testng.report.ReporterUtil;
import com.qmetry.qaf.automation.testng.report.TestOverview;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class QAFReporter {
    private static final Log logger = LogFactoryImpl.getLog(ReporterUtil.class);
    private static final String QAF_TEST_IDENTIFIER = "qaf_test_identifier";
    private static AtomicInteger passCnt = new AtomicInteger(0);
    private static AtomicInteger failCnt = new AtomicInteger(0);
    private static AtomicInteger skipCnt = new AtomicInteger(0);
    private static AtomicInteger indexer = new AtomicInteger(0);

    public static void updateMetaInfo() {
        QAFReporter.createMetaInfo(false);
    }

    public static void createMetaInfo() {
        QAFReporter.createMetaInfo(true);
        QAFReporter.updateOverview(null, true);
    }

    private static void createMetaInfo(boolean bl) {
        String string = ConfigurationManager.getBundle().getString("suite.name", new File(".").getAbsoluteFile().getParentFile().getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(QAFReporter.getTestName());
        String string2 = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0]);
        Report report = new Report();
        if (!ConfigurationManager.getBundle().containsKey("suit.start.ts")) {
            string2 = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[]{ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}) + "/" + DateUtil.getDate((int)0, (String[])new String[]{"EdMMMyy_hhmmssa"})});
            ConfigurationManager.getBundle().setProperty(ApplicationProperties.JSON_REPORT_DIR.key, (Object)string2);
            FileUtil.checkCreateDir((String)ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}));
            FileUtil.checkCreateDir((String)string2);
            ConfigurationManager.getBundle().setProperty("suit.start.ts", (Object)System.currentTimeMillis());
        } else {
            report.setEndTime(System.currentTimeMillis());
        }
        report.setName(string);
        report.setTests(arrayList);
        report.setDir(string2);
        int n = passCnt.get();
        int n2 = failCnt.get();
        int n3 = skipCnt.get();
        int n4 = 0;
        report.setPass(n);
        report.setFail(n2);
        report.setSkip(n3);
        report.setTotal(n + n2 + n3 > n4 ? n + n2 + n3 : n4);
        report.setStatus(n2 > 0 ? "fail" : (n > 0 ? "pass" : "unstable"));
        report.setStartTime(Long.valueOf(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L)));
        QAFReporter.appendReportInfo(report);
        if (bl) {
            ReportEntry reportEntry = new ReportEntry();
            reportEntry.setName(string);
            reportEntry.setStartTime(Long.valueOf(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L)));
            reportEntry.setDir(string2);
            QAFReporter.appendMetaInfo(reportEntry);
        }
    }

    public static synchronized void updateOverview(String string, boolean bl) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            String string2 = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0]) + "/" + QAFReporter.getTestName() + "/overview.json";
            TestOverview testOverview = (TestOverview)JSONUtil.getJsonObjectFromFile((String)string2, TestOverview.class);
            if (bl) {
                Object object;
                HashMap<Object, String> hashMap = new HashMap<Object, String>();
                Configuration configuration = ConfigurationManager.getBundle().subset("env");
                Iterator iterator = configuration.getKeys();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    hashMap.put(object, configuration.getString((String)object));
                }
                object = new HashMap();
                object.put("isfw-build-info", ConfigurationManager.getBundle().getObject("isfw.build.info"));
                object.put("run-parameters", hashMap);
                object.put("browser-desired-capabilities", ConfigurationManager.getBundle().getObject("driver.desiredCapabilities"));
                object.put("browser-actual-capabilities", QAFReporter.getActualCapabilities());
                testOverview.setEnvInfo((Map)object);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("os.name", System.getProperty("os.name"));
                hashMap2.put("os.version", System.getProperty("os.version"));
                hashMap2.put("os.arch", System.getProperty("os.arch"));
                hashMap2.put("java.version", System.getProperty("java.version"));
                hashMap2.put("java.vendor", System.getProperty("java.vendor"));
                hashMap2.put("java.arch", System.getProperty("sun.arch.data.model"));
                hashMap2.put("user.name", System.getProperty("user.name"));
                try {
                    hashMap2.put("host", InetAddress.getLocalHost().getHostName());
                }
                catch (Exception exception) {
                    String string3 = QAFReporter.execHostName("hostname");
                    hashMap2.put("host", string3);
                }
                object.put("execution-env-info", hashMap2);
            }
            testOverview.setTotal((n4 = (n3 = passCnt.get()) + (n2 = failCnt.get()) + (n = skipCnt.get())) > n3 + n2 + n ? n4 : n3 + n2 + n);
            testOverview.setPass(n3);
            testOverview.setSkip(n);
            testOverview.setFail(n2);
            if (null != string) {
                testOverview.getClasses().add(string);
            }
            if (testOverview.getStartTime() > 0L) {
                testOverview.setEndTime(Long.valueOf(System.currentTimeMillis()));
            } else {
                testOverview.setStartTime(Long.valueOf(System.currentTimeMillis()));
            }
            JSONUtil.writeJsonObjectToFile((String)string2, (Object)testOverview);
            QAFReporter.updateMetaInfo();
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
        }
    }

    private static Map<String, String> getActualCapabilities() {
        Map map = (Map)ConfigurationManager.getBundle().getObject("driver.actualCapabilities");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != map) {
            for (String string : map.keySet()) {
                try {
                    hashMap.put(string, String.valueOf(map.get(string)));
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    public static void createMethodResult(String string, Bdd2Pickle bdd2Pickle, long l, String string2, Throwable throwable, List<LoggingBean> list, List<CheckpointResultBean> list2) {
        try {
            String string3 = QAFReporter.getClassDir(QAFReporter.getTestName() + "/" + string);
            MethodResult methodResult = new MethodResult();
            methodResult.setSeleniumLog(list);
            methodResult.setCheckPoints(list2);
            methodResult.setThrowable(throwable);
            String string4 = QAFReporter.getMethodIdentifier(bdd2Pickle);
            String string5 = string3 + "/" + string4;
            File file = new File(string5 + ".json");
            bdd2Pickle.getMetaData().remove(QAF_TEST_IDENTIFIER);
            if (file.exists()) {
                String string6 = "_" + indexer.incrementAndGet();
                string4 = string4 + string6;
                string5 = string3 + "/" + string4;
                QAFReporter.updateClassMetaInfo(bdd2Pickle, l, string2, string4, string);
            } else {
                QAFReporter.updateClassMetaInfo(bdd2Pickle, l, string2, string4, string);
            }
            JSONUtil.writeJsonObjectToFile((String)(string5 + ".json"), (Object)methodResult);
        }
        catch (Exception exception) {
            logger.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static synchronized void updateClassMetaInfo(Bdd2Pickle bdd2Pickle, long l, String string, String string2, String string3) {
        String string4 = QAFReporter.getClassDir(QAFReporter.getTestName() + "/" + string3);
        String string5 = string4 + "/meta-info.json";
        FileUtil.checkCreateDir((String)string4);
        ClassInfo classInfo = (ClassInfo)JSONUtil.getJsonObjectFromFile((String)string5, ClassInfo.class);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setStartTime(System.currentTimeMillis() - l);
        methodInfo.setDuration(l);
        Map<String, Object> map = bdd2Pickle.getMetaData();
        if (null != bdd2Pickle.getTestData()) {
            methodInfo.setArgs(new Object[]{bdd2Pickle.getTestData()});
        }
        methodInfo.setMetaData(map);
        methodInfo.setType("test");
        methodInfo.setResult(QAFReporter.getResult(string));
        if (StringUtil.isNotBlank((String)string2)) {
            map.put("resultFileName", string2);
        }
        QAFReporter.updateOverview(string3, false);
        if (!classInfo.getMethods().contains(methodInfo)) {
            logger.debug((Object)("method:  result: " + methodInfo.getResult() + " groups: " + methodInfo.getMetaData()));
            classInfo.getMethods().add(methodInfo);
            JSONUtil.writeJsonObjectToFile((String)string5, (Object)classInfo);
        } else {
            logger.warn((Object)("methodInfo already wrritten for " + methodInfo.getName()));
        }
    }

    private static String getMethodName(Bdd2Pickle bdd2Pickle) {
        return bdd2Pickle.getName();
    }

    private static String getMethodIdentifier(Bdd2Pickle bdd2Pickle) {
        String string;
        String string2 = QAFReporter.getMethodName(bdd2Pickle);
        String string3 = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal(new String[]{"testCaseId"});
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(bdd2Pickle.getMetaData());
        if (bdd2Pickle.getTestData() != null) {
            treeMap.putAll(bdd2Pickle.getTestData());
        }
        if (StringUtil.isNotBlank((String)(string = treeMap.getOrDefault(string3, "").toString()))) {
            string2 = string;
        }
        if ((string2 = StringUtil.toTitleCaseIdentifier((String)string2)).length() > 45) {
            string2 = string2.substring(0, 45);
        }
        bdd2Pickle.getMetaData().put(QAF_TEST_IDENTIFIER, string2);
        return (String)bdd2Pickle.getMetaData().get(QAF_TEST_IDENTIFIER);
    }

    private static String getClassDir(String string) {
        return ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[]{"test-results"}) + "/" + string;
    }

    private static void appendReportInfo(Report report) {
        String string = report.getDir() + "/meta-info.json";
        JSONUtil.writeJsonObjectToFile((String)string, (Object)report);
    }

    private static void appendMetaInfo(ReportEntry reportEntry) {
        String string = ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal(new String[]{"test-results"}) + "/meta-info.json";
        MetaInfo metaInfo = (MetaInfo)JSONUtil.getJsonObjectFromFile((String)string, MetaInfo.class);
        metaInfo.getReports().remove(reportEntry);
        metaInfo.getReports().add(reportEntry);
        JSONUtil.writeJsonObjectToFile((String)string, (Object)metaInfo);
    }

    private static String getResult(String string) {
        switch (string.toUpperCase().charAt(0)) {
            case 'P': {
                passCnt.incrementAndGet();
                return "pass";
            }
            case 'F': {
                failCnt.incrementAndGet();
                return "fail";
            }
        }
        skipCnt.incrementAndGet();
        return "skip";
    }

    private static String getTestName() {
        return ConfigurationManager.getBundle().getString("testname", "BDD2");
    }

    public static String execHostName(String string) {
        try {
            Process process = Runtime.getRuntime().exec(string);
            InputStream inputStream = process.getInputStream();
            if (inputStream != null) {
                Scanner scanner = new Scanner(inputStream);
                scanner.useDelimiter("\\A");
                String string2 = scanner.hasNext() ? scanner.next() : "";
                inputStream.close();
                scanner.close();
                return string2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }
}

