/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.elasticsearch;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.elasticsearch.ElasticSerachService;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.StringUtil;

public class ElasticSearchIndexer
implements TestCaseResultUpdator {
    public String getToolName() {
        return "Elasticsearch Indexer";
    }

    public boolean updateResult(TestCaseRunResult result) {
        try {
            return ElasticSerachService.submit(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void beforeShutDown() {
        ElasticSerachService.close();
    }

    public boolean allowConfigAndRetry() {
        return false;
    }

    public boolean enabled() {
        return !ApplicationProperties.DRY_RUN_MODE.getBoolenVal(new boolean[]{false}) && StringUtil.isNotBlank((String)ConfigurationManager.getBundle().getString("elasticsearch.host")) && ConfigurationManager.getBundle().getBoolean("elasticsearch.reporter", true);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ElasticSearchIndexer)) {
            return false;
        }
        return this.getToolName().equalsIgnoreCase(((ElasticSearchIndexer)obj).getToolName());
    }
}

