/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.elasticsearch.ElasticSearchClientProvider;
import com.qmetry.qaf.automation.elasticsearch.TestCaseRunResultDocument;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class ElasticSerachService {
    private static final String VER_SUFFIX = "_v1";
    private static final String INDEX_NAME = String.valueOf(ConfigurationManager.getBundle().getString("elasticsearch.index", "qaf_results").toLowerCase()) + "_v1";
    private static final String LOG_INDEX_NAME = String.valueOf(INDEX_NAME) + "_commandlogs";
    private static final String CHKPONIT_INDEX_NAME = String.valueOf(INDEX_NAME) + "_checkpoints";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final ElasticSerachService SERVICE = new ElasticSerachService();
    private RestClient elasticSerachClient;

    private ElasticSerachService() {
        this.init();
    }

    private void init() {
        try {
            this.elasticSerachClient = this.buildElasticSerachClient();
            this.createAssets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createAssets() throws IOException {
        if (this.createIndex(INDEX_NAME)) {
            this.createIndex(CHKPONIT_INDEX_NAME);
            this.createIndex(LOG_INDEX_NAME);
        }
    }

    private boolean createIndex(String name) {
        try {
            Request request = new Request(METHOD_PUT, String.valueOf(name) + "/");
            request.setJsonEntity(ConfigurationManager.getBundle().getString("elasticsearch." + name + ".entity", "{\"settings\":{\"index.mapping.total_fields.limit\":10000}}"));
            Response response = this.elasticSerachClient.performRequest(request);
            return response.getStatusLine().getStatusCode() == 201;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private RestClient buildElasticSerachClient() {
        String providerClass = ConfigurationManager.getBundle().getString("elasticsearch.client.provider", "");
        if (StringUtil.isNotBlank((String)providerClass)) {
            try {
                ElasticSearchClientProvider provider = (ElasticSearchClientProvider)Class.forName(providerClass).newInstance();
                return provider.buildElasticSerachClient();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        String[] hoststr = ConfigurationManager.getBundle().getStringArray("elasticsearch.host", new String[0]);
        return RestClient.builder((HttpHost[])((HttpHost[])Arrays.stream(hoststr).map(s -> HttpHost.create((String)s)).toArray(HttpHost[]::new))).build();
    }

    public static RestClient getElasticSerachClient() {
        return ElasticSerachService.SERVICE.elasticSerachClient;
    }

    public static boolean perform(Request request) {
        if (ElasticSerachService.SERVICE.elasticSerachClient != null) {
            try {
                int status = ElasticSerachService.SERVICE.elasticSerachClient.performRequest(request).getStatusLine().getStatusCode();
                return status == 200 || status == 201;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
        return false;
    }

    public static boolean submit(TestCaseRunResult result) {
        TestCaseRunResultDocument doc = new TestCaseRunResultDocument(result);
        UUID id = doc.getUdid();
        Gson gson = new Gson();
        Request request = new Request(METHOD_POST, String.valueOf(INDEX_NAME) + "/_doc/" + id);
        request.setJsonEntity(gson.toJson((Object)doc));
        boolean success = ElasticSerachService.perform(request);
        request = new Request(METHOD_POST, String.valueOf(CHKPONIT_INDEX_NAME) + "/_doc/" + id);
        doc = new TestCaseRunResultDocument();
        doc.setUdid(id);
        doc.setSteps(result.getCheckPoints());
        doc.setStTime(result.getStarttime());
        request.setJsonEntity(gson.toJson((Object)doc));
        success = ElasticSerachService.perform(request);
        request = new Request(METHOD_POST, String.valueOf(LOG_INDEX_NAME) + "/_doc/" + id);
        doc = new TestCaseRunResultDocument();
        doc.setUdid(id);
        doc.setCommands(result.getCommandLogs());
        doc.setStTime(result.getStarttime());
        request.setJsonEntity(gson.toJson((Object)doc));
        success = ElasticSerachService.perform(request);
        if (success && ConfigurationManager.getBundle().containsKey("project.cyclename")) {
            ElasticSerachService.updateCycle(doc);
        }
        return success;
    }

    private static void updateCycle(TestCaseRunResultDocument doc) {
        try {
            Response res;
            Request request;
            String cycle = ConfigurationManager.getBundle().getString("project.cyclename");
            String status = doc.getStatus();
            String tcname = doc.getName();
            String lastsuccess = doc.getStTime();
            String lastsuccesscycle = cycle;
            if (!status.equalsIgnoreCase("pass")) {
                try {
                    String jsonEntity = String.format("{\"query\":\"select executionInfo.project.cyclename, stTime from \\\"%s\\\" where executionInfo.project.cyclename IS NOT NULL AND status = 'PASS' AND name = '%s' order by stTime DESC limit 1\"}", INDEX_NAME, tcname);
                    request = new Request(METHOD_POST, "/_sql");
                    request.setJsonEntity(jsonEntity);
                    res = ElasticSerachService.SERVICE.elasticSerachClient.performRequest(request);
                    String resStr = EntityUtils.toString((HttpEntity)res.getEntity());
                    JsonArray result = JSONUtil.getGsonElement((String)resStr).getAsJsonObject().get("rows").getAsJsonArray();
                    if (result != null && result.size() > 0 && (result = result.get(0).getAsJsonArray()) != null && result.size() == 2) {
                        lastsuccesscycle = result.get(0).getAsString();
                        lastsuccess = result.get(1).getAsString();
                    }
                }
                catch (Error | Exception throwable) {
                    lastsuccesscycle = null;
                    lastsuccess = null;
                }
            }
            String updateReqBody = String.format("{\"script\": { \"source\": \"ctx._source['laststatus'] = '%s'; if('%s'!='null'){ctx._source['lastsuccess'] = '%s'; ctx._source['lastsuccesscycle'] = '%s';}\"}, \"query\": { \"query_string\": { \"query\": \"executionInfo.project.cyclename: '%s' AND name: '%s'\" } }}", status, lastsuccess, lastsuccess, lastsuccesscycle, cycle, tcname);
            request = new Request(METHOD_POST, String.valueOf(INDEX_NAME) + "/_update_by_query?conflicts=proceed&refresh");
            request.setJsonEntity(updateReqBody);
            res = ElasticSerachService.SERVICE.elasticSerachClient.performRequest(request);
            if (res.getStatusLine().getStatusCode() != 200) {
                System.err.println(EntityUtils.toString((HttpEntity)res.getEntity()));
            }
        }
        catch (Error | Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void close() {
        if (ElasticSerachService.SERVICE.elasticSerachClient != null) {
            try {
                ElasticSerachService.SERVICE.elasticSerachClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

