/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TestCaseRunResultDocument {
    private static final long sttime = System.currentTimeMillis();
    private UUID udid;
    private String name;
    private String status;
    private String className;
    private String stTime;
    private String suite_stTime;
    private Long duration;
    private Map<String, Object> executionInfo;
    private Map<String, Object> metadata;
    private String testData;
    private Map<String, Object> exception;
    private Collection<CheckpointResultBean> steps;
    private Collection<LoggingBean> commands;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";

    public TestCaseRunResultDocument() {
    }

    public TestCaseRunResultDocument(TestCaseRunResult result) {
        this.metadata = this.normalizeFields(result.getMetaData());
        this.setName(result);
        this.status = result.getStatus().name();
        this.setStTime(result.getStarttime());
        this.duration = result.getEndtime() - result.getStarttime();
        this.setException(result);
        this.className = result.getClassName();
        this.executionInfo = this.normalizeFields(result.getExecutionInfo());
        this.executionInfo.put("host", System.getProperty("host.name"));
        this.executionInfo.put("user", System.getProperty("user.name"));
        this.executionInfo.put("os.name", System.getProperty("os.name"));
        this.executionInfo.put("os.version", System.getProperty("os.version"));
        this.executionInfo.put("os.arch", System.getProperty("os.arch"));
        this.executionInfo.put("java.version", System.getProperty("java.version"));
        this.executionInfo.put("java.vendor", System.getProperty("java.vendor"));
        this.executionInfo.put("java.arch", System.getProperty("sun.arch.data.model"));
        this.suite_stTime = DateUtil.getFormatedDate((Date)new Date(ConfigurationManager.getBundle().getLong("execution.start.ts", sttime)), (String)DATE_FORMAT);
        if (!ConfigurationManager.getBundle().subset("project").isEmpty()) {
            this.executionInfo.put("project", this.normalizeFields(ConfigurationConverter.getMap((Configuration)ConfigurationManager.getBundle().subset("project"))));
        }
        this.udid = UUID.nameUUIDFromBytes((String.valueOf(this.stTime) + this.name).getBytes());
        if (result.getTestData() != null && !result.getTestData().isEmpty()) {
            this.setTestData(result.getTestData());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setName(TestCaseRunResult result) {
        this.name = result.getName();
        if (result.getTestData() == null || result.getTestData().isEmpty()) return;
        Object testData1 = result.getTestData().iterator().next();
        String[] metaDataInTestData = ConfigurationManager.getBundle().getStringArray("elasticsearch.metadata.from.testdata");
        if (testData1 instanceof Map) {
            Map testDataMap = (Map)testData1;
            String identifierKey = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal(new String[]{"testCaseId"});
            String identifierVal = testDataMap.getOrDefault(identifierKey, "").toString();
            if (StringUtils.isBlank((String)identifierVal)) {
                identifierVal = testDataMap.getOrDefault("__index", "").toString();
            } else {
                this.metadata.put(identifierKey, identifierVal);
            }
            if (StringUtils.isNotBlank((String)identifierVal)) {
                this.name = String.valueOf(result.getName()) + "-" + identifierVal;
            }
            if (metaDataInTestData == null || metaDataInTestData.length <= 0) return;
            String[] stringArray = metaDataInTestData;
            int n = metaDataInTestData.length;
            int n2 = 0;
            while (n2 < n) {
                String metaKey = stringArray[n2];
                if (testDataMap.containsKey(metaKey)) {
                    this.metadata.put(this.normalizeKey(metaKey), this.normalizeValue(testDataMap.get(metaKey)));
                }
                ++n2;
            }
            return;
        } else {
            try {
                JsonElement obj;
                if (metaDataInTestData == null || metaDataInTestData.length <= 0 || (obj = new Gson().toJsonTree(testData1)) == null || !obj.isJsonObject()) return;
                Map map = (Map)new Gson().fromJson(obj, Map.class);
                String[] stringArray = metaDataInTestData;
                int n = metaDataInTestData.length;
                int n3 = 0;
                while (n3 < n) {
                    String metaKey = stringArray[n3];
                    if (map.containsKey(metaKey)) {
                        this.metadata.put(this.normalizeKey(metaKey), this.normalizeValue(map.get(metaKey)));
                    }
                    ++n3;
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public UUID getUdid() {
        return this.udid;
    }

    public void setUdid(UUID udid) {
        this.udid = udid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getStTime() {
        return this.stTime;
    }

    public void setStTime(String stTime) {
        this.stTime = stTime;
    }

    public void setStTime(long stTime) {
        this.stTime = DateUtil.getFormatedDate((Date)new Date(stTime), (String)DATE_FORMAT);
    }

    public String getSuite_stTime() {
        return this.suite_stTime;
    }

    public void setSuite_stTime(String suite_stTime) {
        this.suite_stTime = suite_stTime;
    }

    public static long getSttime() {
        return sttime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Map<String, Object> getExecutionInfo() {
        return this.executionInfo;
    }

    public void setExecutionInfo(Map<String, Object> executionInfo) {
        this.executionInfo = executionInfo;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String getTestData() {
        return this.testData;
    }

    public void setTestData(String testData) {
        this.testData = testData;
    }

    public void setTestData(Collection<Object> testdata) {
        if (testdata != null) {
            this.testData = JSONUtil.toString(testdata);
        }
    }

    public Map<String, Object> getException() {
        return this.exception;
    }

    public void setException(Map<String, Object> exception) {
        this.exception = exception;
    }

    public void setException(TestCaseRunResult result) {
        try {
            Collection chkPoints;
            List failures;
            Throwable throwable = result.getThrowable();
            if (throwable != null) {
                this.exception = new HashMap<String, Object>();
                this.exception.put("class", ClassUtils.getShortClassName((Object)throwable, (String)"Unknown"));
                ArrayList<String> messages = new ArrayList<String>();
                for (Object o : ExceptionUtils.getThrowableList((Throwable)throwable)) {
                    Throwable cause = (Throwable)o;
                    if (cause == null || !StringUtils.isNotBlank((String)cause.getMessage())) continue;
                    messages.add(StringUtils.abbreviate((String)cause.getMessage(), (int)255));
                }
                if (messages.isEmpty()) {
                    String message = StringUtils.defaultString((String)throwable.getMessage(), (String)ClassUtils.getShortClassName((Object)throwable, (String)"Unknown"));
                    messages.add(StringUtils.abbreviate((String)message, (int)255));
                }
                this.exception.put("messages", messages);
                this.exception.put("detailMessage", ExceptionUtils.getMessage((Throwable)throwable));
                this.exception.put("rootCauseMessage", StringUtils.abbreviate((String)ExceptionUtils.getRootCauseMessage((Throwable)throwable), (int)255));
                this.exception.put("detailStackTrace", ExceptionUtils.getFullStackTrace((Throwable)throwable));
            } else if (!this.status.equalsIgnoreCase("PASS") && (failures = (chkPoints = result.getCheckPoints()).stream().filter(c -> StringMatcher.containsIgnoringCase((String)"fail").match(c.getType())).map(c -> c.getMessage()).collect(Collectors.toList())) != null && !failures.isEmpty()) {
                this.exception = new HashMap<String, Object>();
                this.exception.put("class", "VerificationFailure");
                this.exception.put("messages", failures.stream().map(s -> StringUtils.abbreviate((String)s, (int)255)).collect(Collectors.toList()));
                this.exception.put("detailMessage", String.format("%d verification failed", failures.size()));
                this.exception.put("rootCauseMessage", "verification failed");
                this.exception.put("detailstackTrace", failures.toString());
            }
        }
        catch (Throwable e) {
            System.err.println("[TestCaseRunResultDocument] Unable to setException: " + e.getMessage());
        }
    }

    public Collection<CheckpointResultBean> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<CheckpointResultBean> steps) {
        this.steps = steps;
    }

    public Collection<LoggingBean> getCommands() {
        return this.commands;
    }

    public void setCommands(Collection<LoggingBean> commands) {
        this.commands = commands;
    }

    private Map<String, Object> normalizeFields(Map<String, Object> map) {
        HashMap<String, Object> objToRet = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map<String, Object> val = entry.getValue();
            if (val != null) {
                val = val instanceof Map ? this.normalizeFields(val) : (!val.getClass().isArray() && !(val instanceof Collection) ? String.valueOf(val) : entry.setValue(String.valueOf(val)));
            }
            String key = this.normalizeKey(entry.getKey());
            objToRet.put(key, val);
        }
        return objToRet;
    }

    private Object normalizeValue(Object val) {
        if (val != null) {
            if (val instanceof Map) {
                val = this.normalizeFields((Map)val);
            } else if (!val.getClass().isArray() && !(val instanceof Collection)) {
                val = String.valueOf(val);
            }
        }
        return val;
    }

    private String normalizeKey(String key) {
        if (StringUtil.isBlank((String)key)) {
            return "_value";
        }
        return key.replace('.', '_').toLowerCase();
    }
}

