/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.rest.auth.oauth;

import com.qmetry.qaf.automation.rest.auth.oauth.OAuth2Details;
import com.qmetry.qaf.automation.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OAuthUtils {
    public static OAuth2Details createOAuthDetails(PropertyUtil propertyUtil) {
        OAuth2Details oauthDetails = new OAuth2Details();
        oauthDetails.setAccessToken(propertyUtil.getString("rest.client.oauth.auth.access_token"));
        oauthDetails.setRefreshToken(propertyUtil.getString("rest.client.oauth.auth.refresh_token"));
        oauthDetails.setGrantType(propertyUtil.getString("rest.client.oauth.auth.grant_type"));
        oauthDetails.setClientId(propertyUtil.getString("rest.client.oauth.auth.client_id"));
        oauthDetails.setClientSecret(propertyUtil.getString("rest.client.oauth.auth.client_secret"));
        oauthDetails.setScope(propertyUtil.getString("scope"));
        oauthDetails.setAuthenticationServerUrl(propertyUtil.getString("rest.client.oauth.auth.authentication_server_url"));
        oauthDetails.setUsername(propertyUtil.getString("rest.client.oauth.auth.username"));
        oauthDetails.setPassword(propertyUtil.getString("rest.client.oauth.auth.password"));
        oauthDetails.setResourceServerUrl(propertyUtil.getString("rest.client.oauth.auth.resource_server_url"));
        if (!OAuthUtils.isValid(oauthDetails.getResourceServerUrl())) {
            System.out.println("Resource server url is null. Will assume request is for generating Access token");
            oauthDetails.setAccessTokenRequest(true);
        }
        return oauthDetails;
    }

    public static Properties getClientConfigProps(String path) {
        InputStream is = OAuthUtils.class.getClassLoader().getResourceAsStream(path);
        Properties config = new Properties();
        try {
            config.load(is);
        }
        catch (IOException e) {
            System.out.println("Could not load properties from " + path);
            e.printStackTrace();
            return null;
        }
        return config;
    }

    public static void getProtectedResource(OAuth2Details oauthDetails) {
        String resourceURL = oauthDetails.getResourceServerUrl();
        HttpGet get = new HttpGet(resourceURL);
        get.addHeader("Authorization", OAuthUtils.getAuthorizationHeaderForAccessToken(oauthDetails.getAccessToken()));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        int code = -1;
        try {
            try {
                response = client.execute((HttpUriRequest)get);
                code = response.getStatusLine().getStatusCode();
                if (code == 401 || code == 403) {
                    System.out.println("Access token is invalid or expired. Regenerating access token....");
                    String accessToken = OAuthUtils.getAccessToken(oauthDetails);
                    if (OAuthUtils.isValid(accessToken)) {
                        oauthDetails.setAccessToken(accessToken);
                        get.removeHeaders("Authorization");
                        get.addHeader("Authorization", OAuthUtils.getAuthorizationHeaderForAccessToken(oauthDetails.getAccessToken()));
                        get.releaseConnection();
                        response = client.execute((HttpUriRequest)get);
                        code = response.getStatusLine().getStatusCode();
                        if (code >= 400) {
                            throw new RuntimeException("Could not access protected resource. Server returned http code: " + code);
                        }
                    } else {
                        throw new RuntimeException("Could not regenerate access token");
                    }
                }
                OAuthUtils.handleResponse((HttpResponse)response);
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
                get.releaseConnection();
            }
            catch (IOException e) {
                e.printStackTrace();
                get.releaseConnection();
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public static String getAccessToken(OAuth2Details oauthDetails) {
        HttpPost post = new HttpPost(oauthDetails.getAuthenticationServerUrl());
        String clientId = oauthDetails.getClientId();
        String clientSecret = oauthDetails.getClientSecret();
        String scope = oauthDetails.getScope();
        ArrayList<BasicNameValuePair> parametersBody = new ArrayList<BasicNameValuePair>();
        parametersBody.add(new BasicNameValuePair("rest.client.oauth.auth.grant_type".replace("rest.client.oauth.auth.", ""), oauthDetails.getGrantType()));
        parametersBody.add(new BasicNameValuePair("rest.client.oauth.auth.client_id".replace("rest.client.oauth.auth.", ""), clientId));
        parametersBody.add(new BasicNameValuePair("rest.client.oauth.auth.client_secret".replace("rest.client.oauth.auth.", ""), clientSecret));
        if (OAuthUtils.isValid(scope)) {
            parametersBody.add(new BasicNameValuePair("scope".replace("rest.client.oauth.auth.", ""), scope));
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        String accessToken = null;
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parametersBody, "UTF-8"));
            response = client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            if (code == 401) {
                System.out.println("Authorization server expects Basic authentication");
                post.addHeader("Authorization", OAuthUtils.getBasicAuthorizationHeader(oauthDetails.getClientId(), oauthDetails.getClientSecret()));
                System.out.println("Retry with client credentials");
                post.releaseConnection();
                response = client.execute((HttpUriRequest)post);
                code = response.getStatusLine().getStatusCode();
                if (code == 401 || code == 403) {
                    System.out.println("Could not authenticate using client credentials.");
                    throw new RuntimeException("Could not retrieve access token for client: " + oauthDetails.getClientId());
                }
            }
            Map<String, String> map = OAuthUtils.handleResponse((HttpResponse)response);
            accessToken = map.get("rest.client.oauth.auth.access_token".replace("rest.client.oauth.auth.", ""));
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return accessToken;
    }

    public static Map<String, String> handleResponse(HttpResponse response) {
        String contentType = "application/json";
        if (response.getEntity().getContentType() != null) {
            contentType = response.getEntity().getContentType().getValue();
        }
        if (contentType.contains("application/json")) {
            return OAuthUtils.handleJsonResponse(response);
        }
        if (contentType.contains("application/x-www-form-urlencoded")) {
            return OAuthUtils.handleURLEncodedResponse(response);
        }
        if (contentType.contains("application/xml")) {
            return OAuthUtils.handleXMLResponse(response);
        }
        throw new RuntimeException("Cannot handle " + contentType + " content type. Supported content types include JSON, XML and URLEncoded");
    }

    public static Map<String, String> handleJsonResponse(HttpResponse response) {
        Map oauthLoginResponse = null;
        try {
            oauthLoginResponse = (Map)new JSONParser().parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (org.json.simple.parser.ParseException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            System.out.println("Could not parse JSON response");
            throw e;
        }
        System.out.println();
        System.out.println("********** Response Received **********");
        for (Map.Entry entry : oauthLoginResponse.entrySet()) {
            System.out.println(String.format("  %s = %s", entry.getKey(), entry.getValue()));
        }
        return oauthLoginResponse;
    }

    public static Map<String, String> handleURLEncodedResponse(HttpResponse response) {
        SortedMap<String, Charset> map = Charset.availableCharsets();
        HashMap<String, String> oauthResponse = new HashMap<String, String>();
        Set set = map.entrySet();
        HttpEntity entity = response.getEntity();
        System.out.println();
        System.out.println("********** Response Received **********");
        for (Map.Entry entry : set) {
            System.out.println(String.format("  %s = %s", entry.getKey(), entry.getValue()));
            ((String)entry.getKey()).equalsIgnoreCase("UTF-8");
        }
        try {
            List list = URLEncodedUtils.parse((String)EntityUtils.toString((HttpEntity)entity), (Charset)Charset.forName("UTF-8"));
            for (NameValuePair pair : list) {
                System.out.println(String.format("  %s = %s", pair.getName(), pair.getValue()));
                oauthResponse.put(pair.getName(), pair.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not parse URLEncoded Response");
        }
        return oauthResponse;
    }

    public static Map<String, String> handleXMLResponse(HttpResponse response) {
        HashMap<String, String> oauthResponse = new HashMap<String, String>();
        try {
            String xmlString = EntityUtils.toString((HttpEntity)response.getEntity());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xmlString));
            Document doc = db.parse(inStream);
            System.out.println("********** Response Receieved **********");
            OAuthUtils.parseXMLDoc(null, doc, oauthResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception occurred while parsing XML response");
        }
        return oauthResponse;
    }

    public static void parseXMLDoc(Element element, Document doc, Map<String, String> oauthResponse) {
        NodeList child = null;
        child = element == null ? doc.getChildNodes() : element.getChildNodes();
        int j = 0;
        while (j < child.getLength()) {
            Element childElement;
            if (child.item(j).getNodeType() == 1 && (childElement = (Element)child.item(j)).hasChildNodes()) {
                System.out.println(String.valueOf(childElement.getTagName()) + " : " + childElement.getTextContent());
                oauthResponse.put(childElement.getTagName(), childElement.getTextContent());
                OAuthUtils.parseXMLDoc(childElement, null, oauthResponse);
            }
            ++j;
        }
    }

    public static String getAuthorizationHeaderForAccessToken(String accessToken) {
        return "Bearer " + accessToken;
    }

    public static String getBasicAuthorizationHeader(String username, String password) {
        return "Basic " + OAuthUtils.encodeCredentials(username, password);
    }

    public static String encodeCredentials(String username, String password) {
        String cred = String.valueOf(username) + ":" + password;
        String encodedValue = null;
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        encodedValue = new String(encodedBytes);
        System.out.println("encodedBytes " + new String(encodedBytes));
        byte[] decodedBytes = Base64.decodeBase64((byte[])encodedBytes);
        System.out.println("decodedBytes " + new String(decodedBytes));
        return encodedValue;
    }

    public static boolean isValidInput(OAuth2Details input) {
        if (input == null) {
            return false;
        }
        String grantType = input.getGrantType();
        if (!OAuthUtils.isValid(grantType)) {
            System.out.println("Please provide valid value for grant_type");
            return false;
        }
        if (!OAuthUtils.isValid(input.getAuthenticationServerUrl())) {
            System.out.println("Please provide valid value for authentication server url");
            return false;
        }
        if (!(!grantType.equals("password") || OAuthUtils.isValid(input.getUsername()) && OAuthUtils.isValid(input.getPassword()))) {
            System.out.println("Please provide valid username and password for password grant_type");
            return false;
        }
        if (!(!grantType.equals("client_credentials") || OAuthUtils.isValid(input.getClientId()) && OAuthUtils.isValid(input.getClientSecret()))) {
            System.out.println("Please provide valid client_id and client_secret for client_credentials grant_type");
            return false;
        }
        System.out.println("Validated Input");
        return true;
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() > 0;
    }
}

