/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.gson.Gson;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.rest.RestRequestBean;
import com.qmetry.qaf.automation.rest.WSCRepositoryConstants;
import com.qmetry.qaf.automation.step.QAFTestStep;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.Reporter;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import com.qmetry.qaf.automation.util.Validator;
import com.qmetry.qaf.automation.ws.rest.RestTestBase;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.xmlmatchers.transform.XmlConverters;
import org.xmlmatchers.xpath.HasXPath;

public final class WsStep {
    @QAFTestStep(description="response should have status {status}")
    public static void responseShouldHaveStatus(String status) {
        Validator.assertThat((String)"Response Status", (Object)new RestTestBase().getResponse().getStatus().name(), (Matcher)Matchers.equalToIgnoringCase((String)status));
    }

    @QAFTestStep(description="response should have status code {statusCode}")
    public static void responseShouldHaveStatusCode(int statusCode) {
        Validator.assertThat((String)"Response Status", (Object)new RestTestBase().getResponse().getStatus().getStatusCode(), (Matcher)Matchers.equalTo((Object)statusCode));
    }

    @QAFTestStep(description="response should have xpath {xpath}")
    public static void responseShouldHaveXpath(String xpath) {
        Validator.assertThat((Object)XmlConverters.the((String)new RestTestBase().getResponse().getMessageBody()), (Matcher)HasXPath.hasXPath((String)xpath));
    }

    @QAFTestStep(description="user requests {0}")
    public static ClientResponse userRequests(Object request) {
        RestRequestBean bean = new RestRequestBean();
        bean.fillData(request);
        bean.resolveParameters(null);
        return WsStep.request(bean);
    }

    @QAFTestStep(description="user requests {request} with data {data}", stepName="userRequestsWithData")
    public static ClientResponse userRequests(Object request, Map<String, Object> data) {
        RestRequestBean bean = new RestRequestBean();
        bean.fillData(request);
        bean.resolveParameters(data);
        return WsStep.request(bean);
    }

    @QAFTestStep(description="response should have header {0}")
    public static void responseShouldHaveHeader(String header) {
        Validator.assertThat((Object)new RestTestBase().getResponse().getHeaders(), (Matcher)Matchers.hasKey((Object)header));
    }

    @QAFTestStep(description="response should have header {0} with value {1}")
    public static void responseShouldHaveHeaderWithValue(String header, String value) {
        Validator.assertThat((Object)new RestTestBase().getResponse().getHeaders(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)header), (Matcher)Matchers.hasItem((Object)value)));
    }

    @QAFTestStep(description="response should have {jsonpath}")
    public static void responseShouldHaveJsonPath(String path) {
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        Validator.assertThat((String)("Response Body has " + path), (Object)WsStep.hasJsonPath(new RestTestBase().getResponse().getMessageBody(), path), (Matcher)Matchers.equalTo((Object)true));
    }

    @QAFTestStep(description="response should not have {jsonpath}")
    public static void responseShouldNotHaveJsonPath(String path) {
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        Validator.assertThat((String)("Response Body has not " + path), (Object)WsStep.hasJsonPath(new RestTestBase().getResponse().getMessageBody(), path), (Matcher)Matchers.equalTo((Object)false));
    }

    @QAFTestStep(description="response should have {expectedvalue} at {jsonpath}")
    public static void responseShouldHaveKeyWithValue(Object expectedValue, String path) {
        Object actual;
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        if (Number.class.isAssignableFrom((actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)path, (Predicate[])new Predicate[0])).getClass())) {
            Validator.assertThat((Object)new BigDecimal(String.valueOf(actual)), (Matcher)Matchers.equalTo((Object)new BigDecimal(String.valueOf(expectedValue))));
        } else {
            Validator.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expectedValue));
        }
    }

    @QAFTestStep(description="store response body {0} (in)to {1}")
    public static void storeResponseBodyto(String path, String variable) {
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        Object value = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)path, (Predicate[])new Predicate[0]);
        ConfigurationManager.getBundle().setProperty(variable, value);
    }

    @QAFTestStep(description="response should have value contains {expectedvalue} at {jsonpath}")
    public static void responseShouldHaveKeyAndValueContains(String value, String path) {
        if (!path.startsWith("$")) {
            path = "$." + path;
        }
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)path, (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)String.valueOf(actual), (Matcher)Matchers.containsString((String)value));
    }

    @QAFTestStep(description="store response header {0} (in)to {1}")
    public static void storeResponseHeaderTo(String header, String property) {
        ConfigurationManager.getBundle().setProperty(property, new RestTestBase().getResponse().getHeaders().get((Object)header));
    }

    @QAFTestStep(description="response should be less than {expectedvalue} at {jsonpath}")
    public static void responseShouldLessThan(double expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)Double.parseDouble(String.valueOf(actual)), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(expectedValue)));
    }

    @QAFTestStep(description="response should be less than or equals to {expectedvalue} at {jsonpath}")
    public static void responseShouldLessThanOrEqualsTo(double expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)Double.parseDouble(String.valueOf(actual)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(expectedValue)));
    }

    @QAFTestStep(description="response should be greater than {expectedvalue} at {jsonpath}")
    public static void responseShouldGreaterThan(double expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)Double.parseDouble(String.valueOf(actual)), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(expectedValue)));
    }

    @QAFTestStep(description="response should be greater than or equals to {expectedvalue} at {jsonpath}")
    public static void responseShouldGreaterThanOrEqualsTo(double expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)Double.parseDouble(String.valueOf(actual)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(expectedValue)));
    }

    @QAFTestStep(description="response should have value ignoring case {expectedvalue} at {jsonpath}")
    public static void responseShouldHaveValueIgnoringCase(String expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)String.valueOf(actual), (Matcher)Matchers.equalToIgnoringCase((String)expectedValue));
    }

    @QAFTestStep(description="response should have value contains ignoring case {expectedvalue} at {jsonpath}")
    public static void responseShouldHaveValueContainsIgnoringCase(String expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)String.valueOf(actual).toUpperCase(), (Matcher)Matchers.containsString((String)expectedValue.toUpperCase()));
    }

    @QAFTestStep(description="response should have value matches with {regEx} at {jsonpath}")
    public static void responseShouldHaveValueMatchesWith(String regEx, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)String.valueOf(actual).matches(regEx), (Matcher)Matchers.equalTo((Object)true));
    }

    @QAFTestStep(description="response should not have value {expectedvalue} at {jsonpath}")
    public static void responseShouldNotHaveValue(Object expectedValue, String path) {
        Object actual = JsonPath.read((String)new RestTestBase().getResponse().getMessageBody(), (String)WsStep.getPath(path), (Predicate[])new Predicate[0]);
        Validator.assertThat((Object)actual, (Matcher)Matchers.not((Object)expectedValue));
    }

    @QAFTestStep(description="verify response schema for {0}")
    public static boolean verifyResponseSchema(String requestKey) {
        ProcessingReport result = null;
        try {
            JsonNode responseNode = JsonLoader.fromString((String)new RestTestBase().getResponse().getMessageBody());
            Map map = JSONUtil.toMap((String)ConfigurationManager.getBundle().getString(requestKey, requestKey));
            Object responseSchema = map.get(WSCRepositoryConstants.RESPONSE_SCHEMA);
            if (responseSchema instanceof Map) {
                responseSchema = new Gson().toJson(responseSchema);
            } else {
                File file = new File(responseSchema.toString());
                if (file.exists()) {
                    responseSchema = FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
            }
            JsonNode schemaNode = JsonLoader.fromString((String)String.valueOf(responseSchema));
            JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema(schemaNode);
            result = schema.validate(responseNode);
            if (!result.isSuccess()) {
                for (ProcessingMessage processingMessage : result) {
                    Reporter.log((String)processingMessage.getMessage(), (MessageTypes)MessageTypes.Fail);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ProcessingException e) {
            e.printStackTrace();
        }
        return result != null && result.isSuccess();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientResponse request(RestRequestBean bean) {
        WebResource resource = new RestTestBase().getWebResource(bean.getBaseUrl(), bean.getEndPoint());
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : bean.getQueryParameters().entrySet()) {
            queryParams.add((Object)entry.getKey(), (Object)entry.getValue().toString());
        }
        resource = resource.queryParams((MultivaluedMap)queryParams);
        WebResource.Builder builder = resource.getRequestBuilder();
        for (Map.Entry<String, Object> header : bean.getHeaders().entrySet()) {
            if (header.getKey().equalsIgnoreCase("Accept")) {
                builder.accept(new String[]{(String)header.getValue()});
            }
            builder.header(header.getKey(), header.getValue());
        }
        String body = String.valueOf(bean.getBody());
        if (StringUtil.isNotBlank((String)body)) {
            if (!StringMatcher.startsWithIgnoringCase((String)"file:").match(body)) return (ClientResponse)builder.method(bean.getMethod(), ClientResponse.class, (Object)String.valueOf(body));
            String file = body.split(":", 2)[1];
            try {
                body = FileUtil.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e2) {
                throw new AutomationError("Unable to read file: " + file, (Throwable)e2);
            }
            body = ConfigurationManager.getBundle().getSubstitutor().replace(body);
            return (ClientResponse)builder.method(bean.getMethod(), ClientResponse.class, (Object)String.valueOf(body));
        }
        if (WsStep.isFileUpload(bean.getFormParameters())) {
            String fileName = "";
            try {
                Throwable e2 = null;
                Object var7_11 = null;
                try {
                    ClientResponse clientResponse;
                    FormDataMultiPart multiPart = new FormDataMultiPart();
                    try {
                        Iterator<Map.Entry<String, Object>> iterator = bean.getFormParameters().entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                if (!bean.getHeaders().containsValue("application/octet-stream")) break;
                                Path path = Paths.get(new File(fileName).getAbsolutePath(), new String[0]);
                                clientResponse = (ClientResponse)((WebResource.Builder)builder.type("application/octet-stream")).method(bean.getMethod(), ClientResponse.class, (Object)Files.readAllBytes(path));
                                return clientResponse;
                            }
                            Map.Entry<String, Object> entry = iterator.next();
                            String value = String.valueOf(entry.getValue());
                            if (value.startsWith("file:")) {
                                fileName = value.split("file:", 2)[1];
                                multiPart.bodyPart((BodyPart)new FileDataBodyPart(entry.getKey(), new File(fileName)));
                                continue;
                            }
                            multiPart.field(entry.getKey(), value);
                        }
                        return (ClientResponse)((WebResource.Builder)builder.type("multipart/form-data")).method(bean.getMethod(), ClientResponse.class, (Object)multiPart);
                    }
                    catch (Throwable e2) {
                        throw e2;
                    }
                    finally {
                        if (multiPart == null) return clientResponse;
                        multiPart.close();
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                        throw e2;
                    }
                    if (e2 == throwable) throw e2;
                    e2.addSuppressed(throwable);
                    throw e2;
                }
            }
            catch (Exception e) {
                throw new AutomationError((Throwable)e);
            }
        }
        MultivaluedMapImpl formParam = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : bean.getFormParameters().entrySet()) {
            formParam.add((Object)entry.getKey(), (Object)String.valueOf(entry.getValue()));
        }
        if (!formParam.isEmpty()) return (ClientResponse)builder.method(bean.getMethod(), ClientResponse.class, (Object)formParam);
        return (ClientResponse)builder.method(bean.getMethod(), ClientResponse.class);
    }

    private static boolean hasJsonPath(String json, String path) {
        try {
            JsonPath.read((String)json, (String)path, (Predicate[])new Predicate[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isFileUpload(Map<String, Object> formParameters) {
        for (Map.Entry<String, Object> params : formParameters.entrySet()) {
            String value = String.valueOf(params.getValue()).trim();
            if (!value.startsWith("file:")) continue;
            return true;
        }
        return false;
    }

    private static String getPath(String jsonpath) {
        if (!jsonpath.startsWith("$")) {
            jsonpath = "$." + jsonpath;
        }
        return jsonpath;
    }
}

