/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws;

import com.google.gson.annotations.SerializedName;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.BaseDataBean;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.text.StrSubstitutor;
import org.json.JSONException;
import org.json.JSONObject;

public class WsRequestBean
extends BaseDataBean
implements Serializable {
    private static final long serialVersionUID = 423394605353099602L;
    private String method = "GET";
    private String baseUrl = "";
    private String endPoint = "";
    private Map<String, Object> headers = new HashMap<String, Object>();
    private String[] accept = new String[0];
    private String schema = "";
    private String body = "";
    @SerializedName(value="query-parameters")
    private Map<String, Object> queryParameters = new HashMap<String, Object>();
    @SerializedName(value="form-parameters")
    private Map<String, Object> formParameters = new HashMap<String, Object>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String reference = "";

    public String getBaseUrl() {
        return StringUtil.isNotBlank((String)this.baseUrl) ? this.baseUrl : ApplicationProperties.SELENIUM_BASE_URL.getStringVal(new String[]{""});
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Object> parameters) {
        this.queryParameters = parameters;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endpoint) {
        this.endPoint = endpoint;
    }

    public String[] getAccept() {
        return this.accept;
    }

    public void setAccept(String[] accept) {
        this.accept = accept;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Map<String, Object> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(Map<String, Object> formParameters) {
        this.formParameters = formParameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void resolveParameters(Map<String, Object> data) {
        JSONObject j = new JSONObject((Object)this);
        j.remove("reference");
        String source = this.resolveParameters(j.toString(), data);
        this.fillFromJsonString(source);
        this.removeBlanks(this.formParameters);
        this.removeBlanks(this.queryParameters);
        this.removeBlanks(this.headers);
        if (StringUtil.isNotBlank((String)this.body) && StringMatcher.startsWithIgnoringCase((String)"file:").match(this.body)) {
            String file = this.body.split(":", 2)[1];
            try {
                this.body = FileUtil.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
                this.body = this.resolveParameters(this.body, data);
            }
            catch (IOException e) {
                throw new AutomationError("Unable to read file: " + file, (Throwable)e);
            }
        }
    }

    public void fillData(Object obj) {
        try {
            boolean isString = obj instanceof String;
            if (isString && (ConfigurationManager.getBundle().containsKey((String)obj) || !ConfigurationManager.getBundle().subset((String)obj).isEmpty())) {
                this.fillFromConfig((String)obj);
            } else {
                String jsonStr = isString ? (String)obj : new JSONObject(obj).toString();
                this.fillFromJsonString(jsonStr);
            }
        }
        catch (Exception e) {
            throw new AutomationError("Unable to populate request from" + obj, (Throwable)e);
        }
    }

    public void fillFromConfig(String reqkey) {
        HierarchicalConfiguration.Node node = ConfigurationManager.getBundle().configurationAt(reqkey).getRoot();
        if (!node.hasChildren()) {
            this.fillFromJsonString(ConfigurationManager.getBundle().getString(reqkey));
        } else {
            Configuration config = ConfigurationManager.getBundle().subset(reqkey);
            Iterator keys = config.getKeys();
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String dataKey = String.valueOf(keys.next());
                String value = config.getString(dataKey);
                map.put(dataKey, value);
            }
            this.fillData(map);
        }
    }

    public void fillData(Map<String, Object> map) {
        if (map.containsKey("reference")) {
            this.fillFromConfig((String)map.get("reference"));
        }
        this.updateKey(map, "form-parameters", "formParameters");
        this.updateKey(map, "query-parameters", "queryParameters");
        super.fillData(map);
    }

    public void fillFromJsonString(String jsonstr) {
        try {
            JSONObject jsonObject = new JSONObject(jsonstr);
            String[] keys = JSONObject.getNames((JSONObject)jsonObject);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                try {
                    map.put(key, jsonObject.getJSONObject(key).toString());
                }
                catch (Exception exception) {
                    map.put(key, jsonObject.get(key).toString());
                }
                ++n2;
            }
            this.fillData(map);
        }
        catch (JSONException e) {
            throw new AutomationError(String.valueOf(jsonstr) + " is not valid Json", (Throwable)e);
        }
    }

    public void setFormParameters(String val) {
        this.setMap(val, this.formParameters);
    }

    public void setQueryParameters(String val) {
        this.setMap(val, this.queryParameters);
    }

    public void setHeaders(String val) {
        this.setMap(val, this.headers);
    }

    public void setParameters(String val) {
        this.setMap(val, this.parameters);
    }

    private String resolveParameters(String source, Map<String, Object> data) {
        if (data != null && !data.isEmpty()) {
            source = StrSubstitutor.replace((Object)source, data);
        }
        source = StrSubstitutor.replace((Object)source, this.getParameters());
        source = ConfigurationManager.getBundle().getSubstitutor().replace(source);
        return source;
    }

    private void setMap(String val, Map<String, Object> map) {
        if (StringUtil.isNotBlank((String)val)) {
            JSONObject jsonObject = new JSONObject(val);
            map.putAll(jsonObject.toMap());
        }
    }

    private void updateKey(Map<String, Object> map, String oldKey, String newKey) {
        if (map.containsKey(oldKey)) {
            Object value = map.remove(oldKey);
            map.put(newKey, value);
        }
    }

    private void removeBlanks(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Object> entry = itr.next();
            if (entry.getValue() != null && !StringUtil.isBlank((String)entry.getValue().toString())) continue;
            itr.remove();
        }
    }

    public static void main(String[] args) {
        ConfigurationManager.getBundle().setProperty("env.baseurl", (Object)"http://httpbin.org");
        ConfigurationManager.getBundle().setProperty("get.sample.ref", (Object)"{'headers':{},'endPoint':'/post','baseUrl':'${env.baseurl}','method':'POST','query-parameters':{'param1':'${val1}','param2':'${val2}'},'form-parameters':{'a':'b','i':'${i}','j':'${j}','k':10.01},'body':'','parameters':{'val1':'abc','val2':'xyz','i':10,'j':20}}");
        ConfigurationManager.getBundle().setProperty("get.sample.call", (Object)"{'reference':'get.sample.ref','parameters':{'val1':'','val3':'xyz123','i':20,'j':''},'body':'fileabcd123'}");
        WsRequestBean r = new WsRequestBean();
        r.fillData("get.sample.call");
        System.out.println(r);
        r.resolveParameters(null);
        System.out.println(r);
    }
}

