/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws.client;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ws.rest.RestClientFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import java.util.Arrays;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class NTLMAuthClient
extends RestClientFactory {
    private static final String USERNAME = ConfigurationManager.getBundle().getString("ntlm.user");
    private static final String PASSWORD = ConfigurationManager.getBundle().getString("ntlm.password");
    private static final String WORKSTATION = ConfigurationManager.getBundle().getString("ntlm.workstation", "");
    private static final String DOMAIN = ConfigurationManager.getBundle().getString("ntlm.domain", "");

    protected Client createClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectionRequestTimeout(30000).setTargetPreferredAuthSchemes(Arrays.asList("NTLM")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(USERNAME, PASSWORD, WORKSTATION, DOMAIN));
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig).build();
        ApacheHttpClient4Handler root = new ApacheHttpClient4Handler((HttpClient)closeableHttpClient, (CookieStore)new BasicCookieStore(), false);
        Client client = new Client((ClientHandler)root);
        return client;
    }
}

