/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws.client;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.StringUtil;
import com.qmetry.qaf.automation.ws.auth.oauth.OAuth2Details;
import com.qmetry.qaf.automation.ws.auth.oauth.OAuthUtils;
import com.qmetry.qaf.automation.ws.rest.DefaultRestClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;

public class OAuthWsClient
extends DefaultRestClient {
    protected Client createClient() {
        Client client = super.createClient();
        client.addFilter(new ClientFilter(){

            public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
                cr.getHeaders().add((Object)"Authorization", (Object)OAuthUtils.getAuthorizationHeaderForAccessToken(this.getAccessToken()));
                return this.getNext().handle(cr);
            }

            private String getAccessToken() {
                String accessToken = ConfigurationManager.getBundle().getString("rest.client.oauth.auth.access_token");
                if (StringUtil.isEmpty((String)accessToken)) {
                    OAuth2Details oauthDetails = OAuthUtils.createOAuthDetails(ConfigurationManager.getBundle());
                    System.out.println(oauthDetails);
                    if (!OAuthUtils.isValidInput(oauthDetails)) {
                        System.out.println("Please provide valid config properties to continue.");
                        System.exit(0);
                    }
                    if (OAuthUtils.isValid(accessToken = OAuthUtils.getAccessToken(oauthDetails))) {
                        ConfigurationManager.getBundle().setProperty("rest.client.oauth.auth.access_token", (Object)accessToken);
                        System.out.println("Successfully generated Access token for client_credentials grant_type: " + accessToken);
                    } else {
                        System.out.println("Could not generate Access token for client_credentials grant_type");
                    }
                }
                return accessToken;
            }
        });
        return client;
    }
}

