/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.HtmlCheckpointResultFormatter;
import com.qmetry.qaf.automation.core.HtmlCommandLogFormatter;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.UiDriver;
import com.qmetry.qaf.automation.ui.UiDriverFactory;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.FluentWait;

public class QAFTestBase {
    private PropertyUtil context;
    private Map<String, UiDriver> driverContext;
    private final Log logger = LogFactoryImpl.getLog(QAFTestBase.class);
    public static final String SELENIUM_DEFAULT_TIMEOUT = "selenium.wait.timeout";
    private boolean prepareForShutdown;
    private ArrayList<LoggingBean> commandLog = new ArrayList();
    private List<CheckpointResultBean> checkPointResults = new ArrayList<CheckpointResultBean>();
    private String[] stb;
    private int verificationErrors = 0;
    private boolean alwaysCaptureScreenShot = false;
    private boolean captureScreenShotOnFailure = false;
    private String lastCapturedScreenShot;
    private String screenShotDir;
    private String reportDir;

    protected QAFTestBase() {
        this.context = new PropertyUtil();
        this.driverContext = new HashMap<String, UiDriver>();
        this.setAlwaysCaptureScreenShot(ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(new boolean[0]));
        this.setScreenShotDir(ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img"));
        this.setReportDir(ApplicationProperties.REPORT_DIR.getStringVal("./"));
    }

    public String getHTMLFormattedLog() {
        return new HtmlCommandLogFormatter().getLog(this.commandLog);
    }

    public List<LoggingBean> getLog() {
        return this.commandLog;
    }

    public String getBrowser() {
        return STBArgs.browser_str.getFrom(this.stb);
    }

    public void tearDown() {
        String[] drivers;
        Map<String, UiDriver> drivercontext = this.getDriverContext();
        String[] stringArray = drivers = drivercontext.keySet().toArray(new String[0]);
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            String driver = stringArray[n2];
            UiDriver uiDriver = drivercontext.get(driver);
            if (uiDriver != null) {
                new UiDriverFactory().tearDown(uiDriver);
            }
            drivercontext.remove(driver);
            ++n2;
        }
    }

    public void setDriver(String driverName) {
        this.stb = STBArgs.browser_str.set(driverName, new String[0]);
    }

    public void setDriver(String driverName, UiDriver driver) {
        this.stb = STBArgs.browser_str.set(driverName, new String[0]);
        this.setUiDriver(driver);
    }

    public String getBaseUrl() {
        return STBArgs.base_url.getFrom(this.stb);
    }

    public UiDriver getUiDriver() {
        if (!this.hasUiDriver()) {
            this.init();
        }
        return this.getDriverContext().get(this.getBrowser());
    }

    public static void pause(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isPrepareForShutdown() {
        return this.prepareForShutdown;
    }

    public void setMethod(Method method) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_NAME.key, method.getName());
    }

    public void setPrepareForShutdown(boolean prepareForShutdown) {
        this.prepareForShutdown = prepareForShutdown;
    }

    public String getLastCapturedScreenShot() {
        if (StringUtil.isBlank((String)this.lastCapturedScreenShot)) {
            return "";
        }
        String dir = ApplicationProperties.SCREENSHOT_RELATIVE_PATH.getStringVal(FileUtil.getReletivePath(ApplicationProperties.REPORT_DIR.getStringVal("./"), ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img/")));
        if (!dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        return String.valueOf(dir) + this.lastCapturedScreenShot;
    }

    public void setLastCapturedScreenShot(String lastCapturedScreenShot) {
        this.lastCapturedScreenShot = lastCapturedScreenShot;
    }

    public boolean isVerificationFailed() {
        return this.verificationErrors > 0;
    }

    public void checkForVerificationErrors() {
        if (this.verificationErrors > 0) {
            QAFTestBase.fail(String.valueOf(this.verificationErrors) + " Verification Errors");
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public void claerAssertionsLog() {
        this.clearVerificationErrors();
        this.checkPointResults = new ArrayList<CheckpointResultBean>();
        this.commandLog = new ArrayList();
        this.lastCapturedScreenShot = "";
    }

    public void clearVerificationErrors() {
        this.verificationErrors = 0;
    }

    public int getVerificationErrors() {
        return this.verificationErrors;
    }

    public String getAssertionsLog() {
        return new HtmlCheckpointResultFormatter().getResults(this.checkPointResults);
    }

    public List<CheckpointResultBean> getCheckPointResults() {
        return this.checkPointResults;
    }

    public String getLastCapturedScreenShotFile() {
        return this.lastCapturedScreenShot;
    }

    public void setAlwaysCaptureScreenShot(boolean alwaysCaptureScreenShot) {
        this.alwaysCaptureScreenShot = alwaysCaptureScreenShot;
    }

    public String takeScreenShot() {
        if (!this.hasUiDriver()) {
            return "";
        }
        try {
            this.lastCapturedScreenShot = this.base64ImageToFile(this.getUiDriver().takeScreenShot());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return this.lastCapturedScreenShot;
    }

    public void addVerificationError(Throwable e) {
        this.addAssertionLog(e.getMessage(), MessageTypes.Fail);
        if (!this.logger.isDebugEnabled()) {
            this.logger.error((Object)MessageTypes.Fail.formatText(e.getMessage()));
        } else {
            this.logger.debug((Object)e.getMessage(), e);
        }
    }

    public void addVerificationError(String message) {
        this.addAssertionLog(message, MessageTypes.Fail);
        this.logger.debug((Object)message);
    }

    public void addAssertionLogWithScreenShot(String msg, MessageTypes type) {
        this.takeScreenShot();
        this.addAssertionLog(msg, type);
    }

    public void addAssertionLog(String msg, MessageTypes type) {
        this.logger.debug((Object)type.formatText(msg));
        CheckpointResultBean bean = new CheckpointResultBean();
        bean.setMessage(msg);
        bean.setType(type);
        boolean added = this.addCheckpoint(bean);
        if (added && StringUtil.isBlank((String)this.getLastCapturedScreenShot()) && (ApplicationProperties.FAILURE_SCREENSHOT.getBoolenVal(true) && type.isFailure() || type != MessageTypes.Info && ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(false))) {
            this.takeScreenShot();
        }
        bean.setScreenshot(this.getLastCapturedScreenShot());
        this.setLastCapturedScreenShot("");
        if (type == MessageTypes.Fail) {
            ++this.verificationErrors;
        }
    }

    public PropertyUtil getContext() {
        return this.context;
    }

    protected String getReportDir() {
        return this.reportDir;
    }

    protected boolean isCaptureScreenShotOnFailure() {
        return this.captureScreenShotOnFailure;
    }

    protected void setCaptureScreenShotOnFailure(boolean captureScreetShotOnFailure) {
        this.captureScreenShotOnFailure = captureScreetShotOnFailure;
    }

    protected boolean isAlwaysCaptureScreenShot() {
        return this.alwaysCaptureScreenShot;
    }

    protected String getTestCaseName() {
        return ApplicationProperties.CURRENT_TEST_NAME.getStringVal("QAFTest");
    }

    protected void setScreenShotDir(String screenShotDir) {
        this.screenShotDir = screenShotDir;
        FileUtil.checkCreateDir(screenShotDir);
    }

    protected void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    protected void finalize() throws Throwable {
        this.logger.debug((Object)"Unloading TestBase, cleaning up...");
        this.tearDown();
        super.finalize();
    }

    private void init() {
        if (ApplicationProperties.DRIVER_NAME.getStringVal("").equalsIgnoreCase("")) {
            System.err.println("Driver not configured!... \nUsing " + STBArgs.browser_str.getDefaultVal() + " as default value. Please configure driver to be used using '" + ApplicationProperties.DRIVER_NAME.key + "' property");
        }
        this.stb = this.initStbArgs(new String[0]);
        this.logger.info((Object)("Initializing Driver..." + STBArgs.allToString(this.stb)));
        DriverInitExpectedCondition driverInitExpectedCondition = new DriverInitExpectedCondition(this.commandLog, this.stb);
        UiDriver uiDriver = (UiDriver)new UiDriverInitializer().withTimeout(ApplicationProperties.DRIVER_INIT_TIMEOUT.getIntVal(0), TimeUnit.SECONDS).pollingEvery(10L, TimeUnit.SECONDS).withMessage((Supplier)driverInitExpectedCondition).ignoring(WebDriverException.class).until((Function)driverInitExpectedCondition);
        this.setUiDriver(uiDriver);
        System.out.println("driver init done");
    }

    private boolean hasFailure(List<CheckpointResultBean> subSteps) {
        for (CheckpointResultBean subStep : subSteps) {
            if (!StringMatcher.containsIgnoringCase("fail").match(subStep.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean addCheckpoint(CheckpointResultBean bean) {
        CheckpointResultBean prevCheckpointResultBean;
        int checkPoints = this.checkPointResults.size();
        CheckpointResultBean lastCheckpoint = checkPoints > 1 ? this.checkPointResults.get(checkPoints - 1) : null;
        List<CheckpointResultBean> parent = MessageTypes.TestStep.name().equalsIgnoreCase(bean.getType()) || lastCheckpoint == null || !MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType()) ? this.checkPointResults : lastCheckpoint.getSubCheckPoints();
        CheckpointResultBean checkpointResultBean = prevCheckpointResultBean = !parent.isEmpty() ? parent.get(parent.size() - 1) : null;
        if (prevCheckpointResultBean == null || !prevCheckpointResultBean.equals(bean)) {
            parent.add(bean);
            if (lastCheckpoint != null && MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType())) {
                lastCheckpoint.setType(this.hasFailure(lastCheckpoint.getSubCheckPoints()) ? MessageTypes.TestStepFail : MessageTypes.TestStepPass);
            }
            return true;
        }
        return false;
    }

    private String getScreenShotDir() {
        return this.screenShotDir;
    }

    private String base64ImageToFile(String base64Image) {
        String filename = "";
        try {
            this.lastCapturedScreenShot = filename = FileUtil.saveImageFile(base64Image, StringUtil.createRandomString(this.getTestCaseName()), this.getScreenShotDir());
            this.logger.info((Object)("Capturing screen shot" + this.lastCapturedScreenShot));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in capturing screenshot\n" + e.getMessage()));
        }
        return filename;
    }

    private String[] initStbArgs(String ... args) {
        args = STBArgs.browser_str.setIfEmpty(this.getBrowser(), args);
        return STBArgs.browser_str.setIfEmpty(ApplicationProperties.DRIVER_NAME.getStringVal(STBArgs.browser_str.defaultVal), STBArgs.base_url.setIfEmpty(ApplicationProperties.SELENIUM_BASE_URL.getStringVal(STBArgs.base_url.defaultVal), STBArgs.port.setIfEmpty(ApplicationProperties.REMOTE_PORT.getStringVal(STBArgs.port.defaultVal), STBArgs.sel_server.setIfEmpty(ApplicationProperties.REMOTE_SERVER.getStringVal(STBArgs.sel_server.defaultVal), args))));
    }

    private boolean hasUiDriver() {
        return this.driverContext.get(this.getBrowser()) != null;
    }

    private void setUiDriver(UiDriver uiDriver) {
        this.driverContext.put(this.getBrowser(), uiDriver);
    }

    private Map<String, UiDriver> getDriverContext() {
        return this.driverContext;
    }

    public static void main(String[] args) {
        System.setProperty("driver.name", "chromeDriver");
        System.setProperty("webdriver.chrome.driver", "/Users/chiragjayswal/Downloads/chromedriver");
        System.setProperty("webdriver.gecko.driver", "/Users/chiragjayswal/Downloads/geckodriver");
        new WebDriverTestBase().getDriver().get("http://www.google.com");
        QAFTestBase.pause(5000);
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getBrowser());
        ((QAFTestBase)TestBaseProvider.instance().get()).setDriver("chrome2Driver");
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getBrowser());
        new WebDriverTestBase().getDriver().get("http://www.google.com");
        new WebDriverTestBase().getDriver().findElement("name=q").sendKeys(new CharSequence[]{"firefoxDriver"});
        ((QAFTestBase)TestBaseProvider.instance().get()).setDriver("chromeDriver");
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getBrowser());
        new WebDriverTestBase().getDriver().findElement("name=q").sendKeys(new CharSequence[]{"chromeDriver"});
        QAFTestBase.pause(50000);
        System.exit(0);
    }

    private class DriverInitExpectedCondition
    implements ExpectedCondition<UiDriverFactory, UiDriver>,
    Supplier<String> {
        int count = 0;
        private ArrayList<LoggingBean> commandLog;
        private String[] stb;

        public DriverInitExpectedCondition(ArrayList<LoggingBean> commandLog, String[] stb) {
            this.commandLog = commandLog;
            this.stb = stb;
        }

        public UiDriver apply(UiDriverFactory driverFectory) {
            try {
                ++this.count;
                return driverFectory.get((ArrayList)this.commandLog, this.stb);
            }
            catch (Throwable e) {
                String msg = this.get();
                System.err.println(String.valueOf(msg) + e.getMessage());
                throw new WebDriverException(msg, e.getCause());
            }
        }

        public String get() {
            return "Unable to create driver instance in " + StringUtil.toStringWithSufix(this.count) + " attempt with retry timeout of " + ApplicationProperties.DRIVER_INIT_TIMEOUT.getIntVal(0) + " seconds. You can check/set value of '" + ApplicationProperties.DRIVER_INIT_TIMEOUT.key + "' appropriately to set retry timeout on driver initialization failure.";
        }
    }

    public static enum STBArgs {
        browser_str("firefoxDriver"),
        base_url("http://localhost"),
        sel_server("localhost"),
        port("4444");

        public String defaultVal;

        private STBArgs(String def) {
            this.defaultVal = def;
        }

        public String getFrom(String ... args) {
            if (args != null && args.length > this.ordinal()) {
                return ConfigurationManager.getBundle().getSubstitutor().replace(args[this.ordinal()]);
            }
            return "";
        }

        public static String allToString(String ... args) {
            StringBuilder sb = new StringBuilder();
            STBArgs[] sTBArgsArray = STBArgs.values();
            int n = sTBArgsArray.length;
            int n2 = 0;
            while (n2 < n) {
                STBArgs arg = sTBArgsArray[n2];
                sb.append("," + arg.name() + ":" + arg.getFrom(args));
                ++n2;
            }
            return sb.substring(1);
        }

        public String[] set(String val, String ... args) {
            if (args != null && args.length > this.ordinal()) {
                args[this.ordinal()] = val;
                return args;
            }
            String[] extended = new String[STBArgs.values().length];
            extended[this.ordinal()] = val;
            if (args != null) {
                System.arraycopy(args, 0, extended, 0, args.length);
            }
            return extended;
        }

        public String[] setIfEmpty(String val, String ... args) {
            if (StringUtils.isBlank((String)this.getFrom(args))) {
                return this.set(val, args);
            }
            return args;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }
    }

    private class UiDriverInitializer
    extends FluentWait<UiDriverFactory> {
        public UiDriverInitializer() {
            super((Object)new UiDriverFactory());
        }

        protected RuntimeException timeoutException(String message, Throwable lastException) {
            AutomationError ae = new AutomationError(String.valueOf(message) + "\n" + lastException.getCause().getMessage());
            ae.setStackTrace(lastException.getCause().getStackTrace());
            return ae;
        }
    }
}

