/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.step.client.Scenario;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGScenario
extends TestNGMethod {
    private static final long serialVersionUID = 6225163528424712337L;
    private Scenario scenario;
    private Map<String, Object> metadata;
    private String qualifiledName;

    public TestNGScenario(Method method, IAnnotationFinder finder, XmlTest xmlTest, Object instance) {
        super(method, finder, xmlTest, instance);
        this.init(instance);
    }

    private void init(Object instance) {
        if (Scenario.class.isAssignableFrom(this.getRealClass())) {
            this.scenario = (Scenario)instance;
            if (this.scenario.getPriority() < 1000 || !this.getXmlTest().getParallel().isParallel() || this.getXmlTest().getParallel().equals((Object)XmlSuite.ParallelMode.TESTS)) {
                this.setPriority(this.scenario.getPriority());
            }
            this.setGroups(this.scenario.getM_groups());
            this.setGroupsDependedUpon(this.scenario.getM_groupsDependedUpon(), new ArrayList());
            this.setMethodsDependedUpon(this.scenario.getM_methodsDependedUpon());
            this.setDescription(this.scenario.getDescription());
            this.setEnabled(this.scenario.isM_enabled());
            this.setAlwaysRun(this.scenario.isM_isAlwaysRun());
            this.setIgnoreMissingDependencies(this.scenario.getIgnoreMissingDependencies());
            this.metadata = this.scenario.getMetadata();
            this.qualifiledName = this.scenario.getTestName();
        } else {
            this.metadata = MetaDataScanner.getMetadata(this.getMethod(), true);
            this.qualifiledName = String.valueOf(this.getRealClass().getName()) + "." + this.getMethodName();
        }
        this.metadata.put("name", this.getMethodName());
        this.metadata.put("sign", this.getSignature());
    }

    public String getMethodName() {
        return this.scenario != null ? this.scenario.getTestName() : super.getMethodName();
    }

    public String getSignature() {
        return this.scenario != null ? this.computeSign() : super.getSignature();
    }

    private String computeSign() {
        StringBuilder result = new StringBuilder(this.scenario.getSignature());
        result.append("[pri:").append(this.getPriority()).append(", instance:").append(this.getInstance()).append("]");
        return result.toString();
    }

    public Map<String, Object> getMetaData() {
        return this.metadata;
    }

    public int decAndgetCurrentInvocationCount() {
        this.m_currentInvocationCount = new AtomicInteger(this.getCurrentInvocationCount() - 1);
        return super.getCurrentInvocationCount();
    }

    public String getQualifiedName() {
        return this.qualifiledName;
    }
}

