/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.text;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BDDDefinitionHelper {
    public static String quoteParams(String call) {
        String exp = "(\\s|^)\\$\\{[\\w\\.]*}(\\s|$)";
        Pattern p = Pattern.compile(exp);
        Matcher matcher = p.matcher(call);
        String resultString = new String(call);
        while (matcher.find()) {
            int i = 0;
            while (i <= matcher.groupCount()) {
                String unQuatedparam = matcher.group(i);
                if (StringUtil.isNotBlank((String)unQuatedparam)) {
                    String quatedparam = unQuatedparam.replace("${", "'${").replace("}", "}'");
                    resultString = new String(StringUtil.replace((String)new String(resultString), (String)unQuatedparam, (String)quatedparam));
                }
                ++i;
            }
        }
        return resultString;
    }

    public static List<String[]> getArgs(String call, String def, List<String> argsInDef) {
        ArrayList<String[]> rlst = new ArrayList<String[]>();
        String wcopy = def;
        int i = 0;
        while (i < argsInDef.size()) {
            String curArg = argsInDef.get(i);
            int argPos = wcopy.indexOf(curArg);
            String part = wcopy.substring(0, argPos);
            String result = BDDDefinitionHelper.getFirstMatch(part, call);
            wcopy = wcopy.substring(argPos + curArg.length());
            call = call.substring(result.length());
            String nextGroup = i == argsInDef.size() - 1 ? wcopy : wcopy.substring(0, wcopy.indexOf(argsInDef.get(i + 1)));
            nextGroup = BDDDefinitionHelper.getFirstMatch(nextGroup, call);
            String temp = BDDDefinitionHelper.getFirstMatch(String.valueOf(ParamType.getParamValueRegx()) + nextGroup, call);
            temp = temp.replaceAll(nextGroup, "");
            String[] arg = new String[]{temp, ParamType.getType(temp).name()};
            rlst.add(arg);
            call = call.substring(temp.length());
            ++i;
        }
        return rlst;
    }

    public static List<String[]> getArgsFromCall(String def, String call) {
        return BDDDefinitionHelper.getArgsFromCall(def, call, BDDDefinitionHelper.getArgNames(def));
    }

    public static List<String[]> getArgsFromCall(String def, String call, List<String> defArgPos) {
        ArrayList<String[]> argsToreturn = new ArrayList<String[]>();
        List<String[]> args = BDDDefinitionHelper.getArgs(call, def, defArgPos);
        Pattern num = Pattern.compile(ParamType.LONG.getRegx());
        argsToreturn.addAll(args);
        int i = 0;
        while (i < defArgPos.size()) {
            String posInDef = defArgPos.get(i);
            def = def.replace(posInDef, Pattern.quote(args.get(i)[0]));
            Matcher numMathcher = num.matcher(posInDef);
            int argPos = numMathcher.find() ? Integer.parseInt(numMathcher.group()) : i;
            args.get((int)i)[0] = BDDDefinitionHelper.processArg(args.get(i)[0]);
            argsToreturn.set(argPos, args.get(i));
            ++i;
        }
        return argsToreturn;
    }

    public static boolean matches(String def, String call) {
        String origDef = def;
        def = def.replaceAll(ParamType.getParamDefRegx(), ParamType.getParamValueRegx().replaceAll("\\\\", "\\\\\\\\"));
        if (!StringMatcher.likeIgnoringCase("(((" + BDDKeyword.getKeyWordRegEx() + ")\\s)?" + def + ")").match(call)) {
            return false;
        }
        List<String[]> argsa = BDDDefinitionHelper.getArgsFromCall(origDef, call);
        return BDDDefinitionHelper.getArgNames(def).size() == argsa.size();
    }

    private static String processArg(String s) {
        if (s.startsWith("'") && s.endsWith("'")) {
            s = s.substring(1, s.length() - 1).replaceAll("(\\\\')", "'");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1).replaceAll("(\\\\\")", "\"");
        }
        return s;
    }

    public static List<String> getArgNames(String def) {
        Pattern p = Pattern.compile(ParamType.getParamDefRegx());
        Matcher matcher = p.matcher(def);
        ArrayList<String> args = new ArrayList<String>();
        while (matcher.find()) {
            args.add(matcher.group());
        }
        return args;
    }

    private static String getFirstMatch(String exp, String s) {
        Matcher m = Pattern.compile(exp).matcher(s);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    public static String format(String def, Object ... objects) {
        if (objects == null || objects.length <= 0) {
            return def;
        }
        List<String> args = BDDDefinitionHelper.getArgNames(def);
        if (args.isEmpty() || args.size() != objects.length) {
            return def;
        }
        int i = 0;
        while (i < args.size()) {
            def = StringUtil.replace((String)def, (String)args.get(i), (String)("'" + String.valueOf(objects[i]) + "'"), (int)1);
            ++i;
        }
        return def;
    }

    public static enum BDDKeyword {
        Given,
        When,
        Then,
        And,
        Using,
        Having,
        With;


        public static List<String> getAllKeyWords() {
            ArrayList<String> keywords = new ArrayList<String>();
            BDDKeyword[] bDDKeywordArray = BDDKeyword.values();
            int n = bDDKeywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                BDDKeyword keyword = bDDKeywordArray[n2];
                keywords.add(keyword.name());
                for (String synonym : keyword.getSynonyms()) {
                    keywords.add(synonym);
                }
                ++n2;
            }
            return keywords;
        }

        public static String getKeyWordRegEx() {
            StringBuilder sb = new StringBuilder("^(");
            for (String keyword : BDDKeyword.getAllKeyWords()) {
                sb.append(keyword);
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            return sb.toString();
        }

        public List<String> getSynonyms() {
            ArrayList<String> synonyms = new ArrayList<String>();
            for (Object object : ConfigurationManager.getBundle().getList(this.name())) {
                if (object == null || !StringUtil.isNotBlank((String)object.toString())) continue;
                synonyms.add(object.toString());
            }
            return synonyms;
        }

        public static String getKeywordFrom(String behavior) {
            String regx = BDDKeyword.getKeyWordRegEx();
            Pattern p = Pattern.compile(regx, 2);
            Matcher matcher = p.matcher(behavior);
            if (matcher.find()) {
                return matcher.group();
            }
            return "";
        }
    }

    public static enum ParamType {
        STRING("('([^\\\\']|\\\\\\\\|\\\\')*')|(\"([^\\\\\"]|\\\\\\\\|\\\\\")*\")", "String str"),
        MAP("(\\{.*})", "Map<Object,Object> mapObj"),
        LIST("(\\[.*])", "Object[] objArray"),
        LONG("([-+]?\\d+)", "long l"),
        DOUBLE("([-+]?\\d+(\\.\\d+)?)", "double d"),
        ANY("(.*)", "Object anyObj");

        private String regx;
        String argString;

        private ParamType(String regx, String argString) {
            this.regx = regx;
            this.argString = argString;
        }

        public static ParamType getType(String value) {
            ParamType[] paramTypeArray = ParamType.values();
            int n = paramTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParamType type = paramTypeArray[n2];
                Pattern p = Pattern.compile(type.getRegx());
                Matcher matcher = p.matcher(value);
                if (matcher.matches()) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getRegx() {
            return this.regx;
        }

        public String getArgString() {
            return this.argString;
        }

        public static String getParamValueRegx() {
            StringBuilder sb = new StringBuilder("(");
            sb.append(MAP.getRegx());
            sb.append("|");
            sb.append(LIST.getRegx());
            sb.append("|");
            sb.append(STRING.getRegx());
            sb.append("|");
            sb.append(DOUBLE.getRegx());
            sb.append(")");
            return sb.toString();
        }

        public static String getParamDefRegx() {
            return "\\{([^\\}]).*?}";
        }
    }
}

