/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.api.UiTestBase;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.Reporter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;

public abstract class AbstractTestCase<D, B extends UiTestBase<D>> {
    protected PropertyUtil props = ConfigurationManager.getBundle();
    protected final Log logger = LogFactoryImpl.getLog(this.getClass());
    protected ITestContext context;

    public abstract B getTestBase();

    public D getDriver() {
        return this.getTestBase().getDriver();
    }

    @BeforeGroups(alwaysRun=true)
    @BeforeClass(alwaysRun=true)
    public final void setup(ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        this.context = context;
    }

    @BeforeSuite(alwaysRun=true)
    public final void setupSuit(ITestContext context) {
        this.context = context;
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>(context.getSuite().getXmlSuite().getParameters());
        ConfigurationManager.addAll(params2);
    }

    @BeforeTest(alwaysRun=true)
    public final void setupTest(ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>(context.getCurrentXmlTest().getAllParameters());
        ConfigurationManager.addAll(params2);
        this.context = context;
    }

    @BeforeMethod(alwaysRun=true)
    public final void setupMethod(Method m, ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        this.context = context;
    }

    @AfterMethod(alwaysRun=true)
    public final void afterMethod(ITestContext testContext, ITestResult tr) {
        this.tearDownPrrallelThreads(testContext, "m");
    }

    @AfterGroups(alwaysRun=true)
    public final void afterGroup(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "groups");
    }

    @AfterClass(alwaysRun=true)
    public final void afterClass(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "classes");
    }

    @AfterTest(alwaysRun=true)
    public final void afterTest(ITestContext testContext) {
        this.tearDownPrrallelThreads(testContext, "tests");
    }

    private void tearDownPrrallelThreads(ITestContext testContext, String type) {
        String useSingleSeleniumInstance = ConfigurationManager.getBundle().getString("selenium.singletone", "t");
        if ((useSingleSeleniumInstance.toUpperCase().startsWith(type.substring(0, 1).toUpperCase()) || type.equalsIgnoreCase("tests")) && this.getTestBase() != null) {
            this.getTestBase().tearDown();
        }
    }

    @AfterSuite
    public final void afterSuit(ITestContext testContext) {
        TestBaseProvider.instance().stopAll();
        ResultUpdator.awaitTermination();
    }

    public static boolean verifyTrue(boolean condition, String failMessage, String successMsg) {
        if (condition) {
            Reporter.log(successMsg, MessageTypes.Pass);
        } else {
            Reporter.log(failMessage, MessageTypes.Fail);
        }
        return condition;
    }

    public static boolean verifyFalse(boolean condition, String failMessage, String successMsg) {
        if (!condition) {
            Reporter.log(successMsg, MessageTypes.Pass);
        } else {
            Reporter.log(failMessage, MessageTypes.Fail);
        }
        return !condition;
    }

    public static void assertTrue(boolean condition, String failMessage, String successMsg) {
        if (!AbstractTestCase.verifyTrue(condition, failMessage, successMsg)) {
            throw new AssertionError((Object)failMessage);
        }
    }

    public static void assertFalse(boolean condition, String failMessage, String successMsg) {
        if (!AbstractTestCase.verifyFalse(condition, failMessage, successMsg)) {
            throw new AssertionError((Object)failMessage);
        }
    }
}

