/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.ui.AbstractTestPage;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.api.WebDriverTestPage;
import com.qmetry.qaf.automation.ui.webdriver.ComponentFactory;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebComponent;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;

public abstract class WebDriverBaseTestPage<P extends WebDriverTestPage>
extends AbstractTestPage<P, QAFExtendedWebDriver>
implements WebDriverTestPage {
    public WebDriverBaseTestPage() {
        this(null);
    }

    public WebDriverBaseTestPage(P parent) {
        super(new WebDriverTestBase(), parent);
    }

    @Override
    public String getText() {
        return ((QAFExtendedWebDriver)this.driver).createElement(By.tagName((String)"body")).getText();
    }

    public WebDriverTestBase getTestBase() {
        return (WebDriverTestBase)super.getTestBase();
    }

    @Override
    public void waitForPageToLoad() {
    }

    public <T extends QAFWebComponent> List<T> findElements(String loc, Class<T> t) {
        List<QAFWebElement> eles = ((QAFExtendedWebDriver)this.driver).findElements(loc);
        ArrayList<QAFWebComponent> objs = new ArrayList<QAFWebComponent>();
        for (QAFWebElement ele : eles) {
            QAFWebComponent obj = (QAFWebComponent)ComponentFactory.getObject(t.getClass(), loc, this, (SearchContext)this.driver);
            obj.setId(((QAFExtendedWebElement)ele).getId());
            try {
                Field cacheable = obj.getClass().getDeclaredField("cacheable");
                cacheable.setAccessible(true);
                cacheable.set(obj, true);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            objs.add(obj);
        }
        return objs;
    }

    public <T extends QAFWebComponent> T findElement(String loc, Class<T> t) {
        QAFWebComponent obj = (QAFWebComponent)ComponentFactory.getObject(t.getClass(), loc, this, (SearchContext)this.driver);
        obj.getId();
        return (T)obj;
    }

    @Override
    public void waitForAjaxToComplete() {
        this.getTestBase().getDriver().waitForAjax(new long[0]);
    }

    public void waitForTextPresent(String text) {
        new QAFExtendedWebElement(By.partialLinkText((String)text)).waitForPresent(new long[0]);
    }
}

