/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.util;

import com.google.common.collect.ImmutableList;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public class QAFWebElementWait
extends FluentWait<QAFExtendedWebElement> {
    public QAFWebElementWait(QAFExtendedWebElement element, long timeOutInMiliSeconds) {
        this(element, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInMiliSeconds, QAFWebElementWait.getDefaultInterval());
    }

    public QAFWebElementWait(QAFExtendedWebElement element, long timeOutInMiliSeconds, long sleepInMillis) {
        this(element, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInMiliSeconds, sleepInMillis);
    }

    public QAFWebElementWait(QAFExtendedWebElement QAFExtendedWebElement2, long ... timeout) {
        this(QAFExtendedWebElement2, QAFWebElementWait.getTimeout(timeout), QAFWebElementWait.getInterval(timeout));
    }

    protected QAFWebElementWait(QAFExtendedWebElement element, Clock clock, Sleeper sleeper, long timeOutInMiliSeconds, long sleepTimeOut) {
        super((Object)element, clock, sleeper);
        this.withTimeout(timeOutInMiliSeconds, TimeUnit.MILLISECONDS);
        this.pollingEvery(sleepTimeOut, TimeUnit.MILLISECONDS);
        this.ignore(NoSuchElementException.class, StaleElementReferenceException.class);
    }

    public QAFWebElementWait ignore(Class<? extends RuntimeException> ... exceptionType) {
        return (QAFWebElementWait)this.ignoreAll((Collection)ImmutableList.copyOf((Object[])exceptionType));
    }

    private static long getTimeout(long ... timeout) {
        if (timeout == null || timeout.length < 1 || timeout[0] <= 0L) {
            return QAFWebElementWait.getDefaultTimeout();
        }
        return timeout[0];
    }

    private static long getInterval(long ... timeout) {
        if (timeout == null || timeout.length < 2 || timeout[1] <= 0L) {
            return QAFWebElementWait.getDefaultInterval();
        }
        return timeout[1];
    }

    private static long getDefaultTimeout() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.timeout", ApplicationProperties.SELENIUM_WAIT_TIMEOUT.getIntVal(5000));
    }

    private static long getDefaultInterval() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.interval", ConfigurationManager.getBundle().getLong("selenium.wait.interval", 1000L));
    }
}

