/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.base.Function;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.ui.util.QAFWebDriverWait;
import com.qmetry.qaf.automation.ui.webdriver.ComponentFactory;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.LocatorUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ComponentListHandler
implements InvocationHandler {
    private SearchContext context;
    private String loc;
    private Class<? extends QAFExtendedWebElement> componentClass;
    private Object declaringclassObj;
    private String description;
    private By by;

    public ComponentListHandler(SearchContext context, String loc, Class<? extends QAFExtendedWebElement> cls, Object declaringclassObj) {
        this.context = context;
        this.componentClass = cls;
        this.declaringclassObj = declaringclassObj;
        this.init(loc);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        if (this.context == null) {
            this.context = new WebDriverTestBase().getDriver();
        }
        final ArrayList elements = new ArrayList();
        if (method.getName().equalsIgnoreCase("get")) {
            final int index = (Integer)objects[0];
            new QAFWebDriverWait(new long[0]).withMessage(String.format("Wait timeout for list of %s with size %d", this.description, index + 1)).until((Function)new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

                public Boolean apply(QAFExtendedWebDriver driver) {
                    try {
                        elements.clear();
                        elements.addAll(ComponentListHandler.this.context.findElements(ComponentListHandler.this.by));
                        if (elements.size() > index) {
                            return true;
                        }
                        return false;
                    }
                    catch (WebDriverException webDriverException) {
                        return false;
                    }
                }
            });
        } else {
            elements.clear();
            elements.addAll(this.context.findElements(this.by));
        }
        ArrayList<Object> components = new ArrayList<Object>();
        if (elements != null && !elements.isEmpty()) {
            for (WebElement element : elements) {
                Object component = ComponentFactory.getObject(this.componentClass, this.loc, this.declaringclassObj, this.context);
                QAFExtendedWebElement extendedWebElement = (QAFExtendedWebElement)component;
                extendedWebElement.setId(((QAFExtendedWebElement)element).getId());
                extendedWebElement.cacheable = true;
                extendedWebElement.getMetaData().put("pageClass", this.declaringclassObj.getClass());
                if (this.context != null && this.context instanceof QAFExtendedWebElement) {
                    extendedWebElement.parentElement = (QAFExtendedWebElement)this.context;
                }
                components.add(component);
            }
        }
        try {
            return method.invoke(components, objects);
        }
        catch (Exception e) {
            throw e.getCause();
        }
    }

    private void init(String locator) {
        this.loc = ConfigurationManager.getBundle().getString(locator, locator);
        this.loc = ConfigurationManager.getBundle().getSubstitutor().replace(this.loc);
        this.by = LocatorUtil.getBy(this.loc);
        if (JSONUtil.isValidJsonString(this.loc)) {
            try {
                Map<String, Object> map = JSONUtil.toMap(this.loc);
                String string = map.containsKey("desc") ? (String)map.get("desc") : (this.description = map.containsKey("description") ? (String)map.get("description") : (String)map.get("locator"));
                if (map.containsKey("child") && !((Boolean)map.get("child")).booleanValue()) {
                    this.context = null;
                }
            }
            catch (JSONException jSONException) {
                this.description = this.loc;
            }
        }
    }
}

