/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class PropertyUtil
extends XMLConfiguration {
    private static final long serialVersionUID = -8633909707831110230L;
    Log logger = LogFactoryImpl.getLog(PropertyUtil.class);

    public PropertyUtil() {
        this.setLogger(this.logger);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object[] vals;
            Object[] objectArray;
            String skey = String.valueOf(entry.getKey());
            String sval = String.valueOf(entry.getValue());
            if (StringMatcher.like("^(sun\\.|java\\.).*").match(skey)) continue;
            if (sval != null && sval.indexOf(this.getListDelimiter()) >= 0) {
                objectArray = sval.split(String.valueOf(this.getListDelimiter()));
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = sval;
            }
            Object[] objectArray3 = vals = objectArray;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray3[n2];
                super.addPropertyDirect(skey, val);
                ++n2;
            }
        }
    }

    protected void addPropertyDirect(String key, Object value) {
        if (!System.getProperties().containsKey(key)) {
            if (key.toLowerCase().startsWith("system.")) {
                super.addPropertyDirect(key, value);
                key = key.substring(key.indexOf(".") + 1);
                System.setProperty(key, (String)value);
            }
            super.addPropertyDirect(key, value);
        } else {
            String sysVal = System.getProperty(key);
            if (!sysVal.equalsIgnoreCase(value.toString())) {
                this.logger.debug((Object)("property [" + key + "] value [" + value + "] ignored! It is overriden with System provided value: [" + sysVal + "]"));
            }
        }
    }

    public PropertyUtil(PropertyUtil prop) {
        this();
        this.append((Configuration)prop);
    }

    public PropertyUtil(String ... file) {
        this();
        this.load(file);
    }

    public void addAll(Map<String, String> props) {
        Set<String> keys = props.keySet();
        keys.removeAll(System.getProperties().keySet());
        for (String key : keys) {
            ConfigurationManager.getBundle().setProperty(key, props.get(key));
        }
    }

    public PropertyUtil(File ... file) {
        this();
        this.load(file);
    }

    public boolean load(String ... files) {
        boolean r = true;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            file = this.getSubstitutor().replace(file);
            this.loadFile(new File(file));
            ++n2;
        }
        return r;
    }

    public boolean load(File ... files) {
        boolean r = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.loadFile(file);
            ++n2;
        }
        return r;
    }

    private boolean loadFile(File file) {
        try {
            if (file.getName().endsWith("xml") || file.getName().contains(".xml.")) {
                super.load((InputStream)new FileInputStream(file));
                XMLConfiguration xmlConfiguration = new XMLConfiguration(file);
                this.copy((Configuration)xmlConfiguration);
                xmlConfiguration.clear();
            } else {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
                propertiesConfiguration.setEncoding(this.getString(ApplicationProperties.LOCALE_CHAR_ENCODING.key, "UTF-8"));
                propertiesConfiguration.load((InputStream)new FileInputStream(file));
                this.copy((Configuration)propertiesConfiguration);
                propertiesConfiguration.clear();
            }
            return true;
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e.getMessage());
        }
        return false;
    }

    public boolean load(Class<?> cls, String propertyFile) {
        boolean success;
        block14: {
            success = false;
            InputStream in = null;
            try {
                try {
                    in = cls.getResourceAsStream(propertyFile);
                    this.load(in);
                    success = true;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to load properties from file:" + propertyFile), (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public String[] getStringArray(String key, String ... defaultValue) {
        String[] retVal = super.getStringArray(key);
        return retVal != null && retVal.length > 0 ? retVal : (defaultValue == null ? new String[]{} : defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            String sVal = this.getString(key, "").trim();
            boolean val = StringUtil.booleanValueOf(sVal, defaultValue);
            return val;
        }
        catch (Exception exception) {
            return super.getBoolean(key, defaultValue);
        }
    }

    public Object getObject(String key) {
        return super.getProperty(key);
    }

    public String getPropertyValue(String sPropertyName) {
        return this.getString(sPropertyName, sPropertyName);
    }

    public String getPropertyValueOrNull(String sPropertyName) {
        return this.getString(sPropertyName);
    }

    public void storePropertyFile(File f) {
        try {
            this.save(f);
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    public void addProperty(String key, Object value) {
        this.clearProperty(key);
        super.addProperty(key, value);
    }

    public void editProperty(String key, Object value) {
        super.addProperty(key, value);
    }

    public void clearProperty(String key) {
        if (!System.getProperties().containsKey(key)) {
            super.clearProperty(key);
        } else {
            this.logger.debug((Object)("clear system property ignored:" + key));
        }
    }
}

