/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.util.Reporter;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.testng.SkipException;

public class Validator {
    public static <T> boolean verifyThat(String reason, T actual, Matcher<? super T> matcher) {
        boolean result = matcher.matches(actual);
        StringDescription description = new StringDescription();
        description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     Actual: ");
        matcher.describeMismatch(actual, (Description)description);
        String msg = description.toString();
        if (msg.endsWith("Actual: ")) {
            msg = String.format(String.valueOf(msg) + "%s", actual);
        }
        msg = msg.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        Reporter.log(msg, result ? MessageTypes.Pass : MessageTypes.Fail);
        return result;
    }

    public static <T> boolean verifyThat(T actual, Matcher<? super T> matcher) {
        return Validator.verifyThat("", actual, matcher);
    }

    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        Validator.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        if (!Validator.verifyThat(reason, actual, matcher)) {
            throw new AssertionError();
        }
    }

    public static <T> void givenThat(String reason, T actual, Matcher<? super T> matcher) {
        if (!Validator.verifyThat(reason, actual, matcher)) {
            throw new SkipException("Precondition not satisfied");
        }
    }

    public static <T> void givenThat(T actual, Matcher<? super T> matcher) {
        Validator.givenThat("", actual, matcher);
    }
}

