/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;

public class XPathUtils {
    public static XMLConfiguration read(File xmlFile) throws IOException {
        String xmlsrc = FileUtil.readFileToString((File)xmlFile, (String)"UTF-8");
        return XPathUtils.read(xmlsrc);
    }

    public static XMLConfiguration read(String src) {
        try {
            src = XPathUtils.removeNSAndPreamble(src);
            XMLConfiguration config = new XMLConfiguration();
            config.load((InputStream)new ByteArrayInputStream(src.getBytes()));
            config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
            return config;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String removeNSAndPreamble(String xmlStr) {
        String xsltString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output method=\"xml\" indent=\"yes\" encoding=\"UTF-8\"/><xsl:template match=\"/\"><xsl:copy><xsl:apply-templates/></xsl:copy></xsl:template><xsl:template match=\"@*\"><xsl:attribute name=\"{local-name()}\"><xsl:value-of select=\"current()\"/></xsl:attribute></xsl:template><xsl:template match=\"*\"><xsl:element name=\"{local-name()}\"><xsl:apply-templates select=\"@* | * | text()\"/></xsl:element></xsl:template><xsl:template match=\"text()\"><xsl:copy><xsl:value-of select=\"current()\"/></xsl:copy></xsl:template></xsl:stylesheet>";
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (ByteArrayOutputStream bo = new ByteArrayOutputStream();){
                TransformerFactory factory = TransformerFactory.newInstance();
                StreamSource xslt = new StreamSource(new ByteArrayInputStream(xsltString.getBytes()));
                Transformer transformer = factory.newTransformer(xslt);
                StreamSource xmlSrc = new StreamSource(new ByteArrayInputStream(xmlStr.getBytes()));
                transformer.transform(xmlSrc, new StreamResult(bo));
                return bo.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e1) {
            System.err.println(e1.getMessage());
        }
        System.err.println("Unable to clean Namespace and Preamble from xml source, will use unmodified xml.");
        return xmlStr;
    }

    public static void main(String[] args) throws IOException {
        String s = FileUtil.readFileToString((File)new File("test/resources/xmlWithNS.xml"), (String)"UTF-8");
        System.out.println(XPathUtils.removeNSAndPreamble(s));
    }
}

