/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.ReaderWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;

public class Response {
    private transient String messageBody;
    private ClientResponse clientResponse;
    private MultivaluedMap<String, String> headers;
    private ClientResponse.Status status;
    private MediaType mediaType;
    private List<NewCookie> cookies;
    private Date lastModified;
    private String language;
    private Date responseDate;

    protected Response() {
    }

    public Response(ClientResponse clientResponse) {
        this.init(clientResponse);
    }

    protected void init(ClientResponse clientResponse) {
        this.clientResponse = clientResponse;
        this.headers = clientResponse.getHeaders();
        this.status = clientResponse.getClientResponseStatus();
        this.mediaType = clientResponse.getType();
        this.cookies = clientResponse.getCookies();
        this.lastModified = clientResponse.getLastModified();
        this.responseDate = clientResponse.getResponseDate();
        this.language = clientResponse.getLanguage();
        this.setRawMessageBody();
    }

    private void setRawMessageBody() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = this.clientResponse.getEntityInputStream();
        try {
            ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
            byte[] requestEntity = out.toByteArray();
            if (requestEntity.length == 0) {
                return;
            }
            this.messageBody = new String(requestEntity);
            this.clientResponse.setEntityInputStream((InputStream)new ByteArrayInputStream(requestEntity));
        }
        catch (IOException iOException) {}
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public <T> T getEntity(Class<T> t) {
        return (T)this.clientResponse.getEntity(t);
    }

    public ClientResponse.Status getStatus() {
        return this.status;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public List<NewCookie> getCookies() {
        return this.cookies;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getLanguage() {
        return this.language;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public String toString() {
        return "";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.clientResponse.getEntityInputStream().close();
        }
        catch (IOException iOException) {}
    }
}

