/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws.rest;

import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.ContainerListener;
import com.sun.jersey.api.client.filter.OnStartConnectionListener;
import com.sun.jersey.core.util.ReaderWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestLogger
extends ClientFilter
implements OnStartConnectionListener {
    private final Log logger = LogFactory.getLog(RequestLogger.class);
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = ">> ";
    private static final String RESPONSE_PREFIX = "<< ";
    private final PrintStream loggingStream;
    private long _id = 0L;

    public RequestLogger() {
        this.loggingStream = null;
    }

    public RequestLogger(PrintStream loggingStream) {
        this.loggingStream = loggingStream;
    }

    private void log(String b) {
        this.logger.info((Object)b.toString());
        if (this.loggingStream != null) {
            this.loggingStream.print(b);
        }
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(Long.toString(id)).append(" ");
        return b;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        long id = ++this._id;
        StringBuilder requestString = this.logRequest(id, request);
        LoggingBean loggingBean = new LoggingBean();
        loggingBean.setCommandName(String.valueOf(request.getMethod()) + ":" + request.getURI());
        loggingBean.setArgs(new String[]{request.getURI().getPath(), request.getURI().getQuery()});
        ClientResponse response = this.getNext().handle(request);
        loggingBean.setResult(response.toString());
        StringBuilder responseString = this.logResponse(id, response);
        LoggingBean detailsLoggingBean = new LoggingBean();
        detailsLoggingBean.setArgs(new String[]{this.noPrifix(requestString).toString()});
        detailsLoggingBean.setResult(this.noPrifix(responseString).toString());
        loggingBean.getSubLogs().add(detailsLoggingBean);
        ((QAFTestBase)TestBaseProvider.instance().get()).getLog().add(loggingBean);
        return response;
    }

    private StringBuilder logRequest(long id, ClientRequest request) {
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, id, request);
        this.printRequestHeaders(b, id, (MultivaluedMap<String, Object>)request.getHeaders());
        if (request.getEntity() != null) {
            request.setAdapter((ClientRequestAdapter)new Adapter(request.getAdapter(), b));
        } else {
            this.log(b.toString());
        }
        return b;
    }

    private void printRequestLine(StringBuilder b, long id, ClientRequest request) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append("Client out-bound request").append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getURI().toASCIIString()).append("\n");
    }

    private void printRequestHeaders(StringBuilder b, long id, MultivaluedMap<String, Object> headers) {
        for (Map.Entry e : headers.entrySet()) {
            List val = (List)e.getValue();
            String header = (String)e.getKey();
            if (val.size() == 1) {
                this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(ClientRequest.getHeaderValue(val.get(0))).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (Object o : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append(ClientRequest.getHeaderValue(o));
            }
            this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    private StringBuilder logResponse(long id, ClientResponse response) {
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, id, response);
        this.printResponseHeaders(b, id, (MultivaluedMap<String, String>)response.getHeaders());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = response.getEntityInputStream();
        try {
            ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
            byte[] requestEntity = out.toByteArray();
            this.printEntity(b, requestEntity);
            response.setEntityInputStream((InputStream)new ByteArrayInputStream(requestEntity));
        }
        catch (IOException ex) {
            throw new ClientHandlerException((Throwable)ex);
        }
        this.log(b.toString());
        return b;
    }

    private void printResponseLine(StringBuilder b, long id, ClientResponse response) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append("Client in-bound response").append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).append("\n");
    }

    private void printResponseHeaders(StringBuilder b, long id, MultivaluedMap<String, String> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                this.prefixId(b, id).append(RESPONSE_PREFIX).append(header).append(": ").append(value).append("\n");
            }
        }
        this.prefixId(b, id).append(RESPONSE_PREFIX).append("\n");
    }

    private void printEntity(StringBuilder b, byte[] entity) throws IOException {
        if (entity.length == 0) {
            return;
        }
        b.append(new String(entity)).append("\n");
    }

    private StringBuilder noPrifix(StringBuilder sb) {
        RequestLogger.deleteAll(sb, String.valueOf(Long.toString(this._id)) + " " + REQUEST_PREFIX);
        RequestLogger.deleteAll(sb, String.valueOf(Long.toString(this._id)) + " " + RESPONSE_PREFIX);
        RequestLogger.deleteAll(sb, String.valueOf(Long.toString(this._id)) + " " + NOTIFICATION_PREFIX);
        return sb;
    }

    public static void deleteAll(StringBuilder builder, String str) {
        if (builder == null) {
            return;
        }
        int index = builder.indexOf(str);
        while (index != -1) {
            builder.delete(index, index + str.length());
            index = builder.indexOf(str, index);
        }
    }

    public ContainerListener onStart(ClientRequest cr) {
        return new ContainerListener(){

            public void onSent(long delta, long bytes) {
                RequestLogger.this.log(RequestLogger.this.prefixId(new StringBuilder(), RequestLogger.this._id).append(RequestLogger.NOTIFICATION_PREFIX).append("Sent: delta: ").append(delta).append(" bytes: ").append(bytes).append("\n").toString());
            }

            public void onReceiveStart(long totalBytes) {
                RequestLogger.this.log(RequestLogger.this.prefixId(new StringBuilder(), RequestLogger.this._id).append(RequestLogger.NOTIFICATION_PREFIX).append("Receive Start: ").append(totalBytes).append("\n").toString());
            }

            public void onReceived(long delta, long bytes) {
                RequestLogger.this.log(RequestLogger.this.prefixId(new StringBuilder(), RequestLogger.this._id).append(RequestLogger.NOTIFICATION_PREFIX).append("Received: delta: ").append(delta).append(" bytes: ").append(bytes).append("\n").toString());
            }

            public void onFinish() {
                RequestLogger.this.log("Finished");
                RequestLogger.this.log(RequestLogger.this.prefixId(new StringBuilder(), RequestLogger.this._id).append(RequestLogger.NOTIFICATION_PREFIX).append("Finished").append("\n").toString());
            }
        };
    }

    private final class Adapter
    extends AbstractClientRequestAdapter {
        private final StringBuilder b;

        Adapter(ClientRequestAdapter cra, StringBuilder b) {
            super(cra);
            this.b = b;
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new LoggingOutputStream(this.getAdapter().adapt(request, out), this.b);
        }
    }

    private final class LoggingOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final StringBuilder b;

        LoggingOutputStream(OutputStream out, StringBuilder b) {
            this.out = out;
            this.b = b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.baos.write(b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.baos.write(b);
            this.out.write(b);
        }

        @Override
        public void close() throws IOException {
            RequestLogger.this.printEntity(this.b, this.baos.toByteArray());
            RequestLogger.this.log(this.b.toString());
            this.out.close();
        }
    }
}

