/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.qmetry.qaf.automation.step.client.Scenario;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod m = iTestNGMethodArray[n2];
            this.m_dependencies.put((Object)m.getQualifiedName(), (Object)m);
            String[] stringArray = m.getGroups();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String g = stringArray[n4];
                this.m_groups.put((Object)g, (Object)m);
                ++n4;
            }
            ++n2;
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group, ITestNGMethod fromMethod) {
        Set uniqueKeys = this.m_groups.keySet();
        List result = Lists.newArrayList();
        for (String k : uniqueKeys) {
            if (!Pattern.matches(group, k)) continue;
            result.addAll(this.m_groups.get((Object)k));
        }
        if (result.isEmpty() && !fromMethod.ignoreMissingDependencies()) {
            throw new TestNGException("DependencyMap::Method \"" + fromMethod + "\" depends on nonexistent group \"" + group + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List l = (List)this.m_dependencies.get((Object)methodName);
        if (l.isEmpty() && fromMethod.ignoreMissingDependencies()) {
            return fromMethod;
        }
        for (ITestNGMethod m : l) {
            if (fromMethod.getRealClass().isAssignableFrom(m.getRealClass())) {
                if (m.getInstance() != fromMethod.getInstance() && !m.getRealClass().isAssignableFrom(Scenario.class)) continue;
                return m;
            }
            return m;
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }
}

