/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.core.ClassFinder;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.util.List;

public class ClassFinderFactory {
    public static ClassFinder getClassFinder() {
        String clsFinderImpl = ConfigurationManager.getBundle().getString("class.finder");
        if (StringUtil.isNotBlank((String)clsFinderImpl)) {
            try {
                Class<?> cls = Class.forName(clsFinderImpl);
                return (ClassFinder)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Unable to initiate " + clsFinderImpl + "\n Will use default class finder");
            }
        }
        return new DefaultClassFinder();
    }

    public static class DefaultClassFinder
    implements ClassFinder {
        @Override
        public List<Class<?>> getClasses(String pkg) throws IOException {
            return ClassUtil.getClasses(pkg);
        }
    }
}

