/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.ui.webdriver.ChromeDriverHelper;
import java.util.Iterator;
import java.util.Vector;

public class TestBaseProvider
extends ThreadLocal<QAFTestBase> {
    private final Vector<QAFTestBase> lst = new Vector();
    private static final TestBaseProvider INSTANCE = new TestBaseProvider();

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TestBaseProvider.instance().prepareForShutDown();
                TestBaseProvider.instance().stopAll();
                ChromeDriverHelper.teardownService();
            }
        });
    }

    @Override
    protected QAFTestBase initialValue() {
        QAFTestBase stb = new QAFTestBase();
        this.lst.add(stb);
        return stb;
    }

    @Override
    public void remove() {
        ((QAFTestBase)this.get()).tearDown();
        super.remove();
    }

    @Override
    public void set(QAFTestBase value) {
        if (value == null) {
            this.remove();
        } else {
            super.set(value);
        }
    }

    public Vector<QAFTestBase> getAll() {
        return this.lst;
    }

    public void stopAll() {
        Iterator<QAFTestBase> iter = this.lst.iterator();
        while (iter.hasNext()) {
            iter.next().tearDown();
            iter.remove();
        }
    }

    public void prepareForShutDown() {
        Iterator<QAFTestBase> iter = this.lst.iterator();
        while (iter.hasNext()) {
            System.out.println("Preparing For Shut Down...");
            iter.next().setPrepareForShutdown(true);
        }
    }

    public static TestBaseProvider instance() {
        return INSTANCE;
    }

    private TestBaseProvider() {
    }
}

