/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.qmetry.qaf.automation.data.BaseFormDataBean;
import com.qmetry.qaf.automation.data.ElementInteractor;
import com.qmetry.qaf.automation.ui.annotations.UiElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DataView<B extends BaseFormDataBean> {
    ElementInteractor interactor;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public DataView() {
        this.interactor = new ElementInteractor();
    }

    public String getData(String loc, UiElement.Type type, int ... index) {
        Object val = this.interactor.fetchValue(String.format(loc, new Object[]{index}), type, QAFExtendedWebElement.class);
        return String.valueOf(val);
    }

    UiElement.Type getType(Field fld) {
        UiElement map = fld.getAnnotation(UiElement.class);
        return map != null ? map.fieldType() : UiElement.Type.text;
    }

    public B populateBean(B bean, int ... index) {
        Field[] flds;
        Field[] fieldArray = flds = this.getClass().getDeclaredFields();
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String loc = (String)field.get(this);
                ((BaseFormDataBean)bean).setBeanData(loc, (String)this.getData(loc, this.getType(field), index));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to set bean field using view field " + field.getName() + ": " + e.getMessage()));
            }
            ++n2;
        }
        return bean;
    }

    public boolean verifyData(B bean, int ... index) {
        Field[] flds = this.getClass().getDeclaredFields();
        boolean outcome = true;
        Field[] fieldArray = flds;
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                String loc = (String)field.get(this);
                Object beanData = ((BaseFormDataBean)bean).getBeanData(loc);
                if (beanData != null) {
                    outcome = this.interactor.verifyValue(String.format(loc, new Object[]{index}), String.valueOf(((BaseFormDataBean)bean).getBeanData(loc)), this.getType(field), QAFExtendedWebElement.class);
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to verify " + field.getName() + ": " + e.getMessage()));
            }
            ++n2;
        }
        return outcome;
    }
}

