/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.annotations.UiElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebComponent;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.Reporter;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;

public class ElementInteractor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Object fetchValue(String loc, UiElement.Type type, Class<? extends QAFExtendedWebElement> eleClass) {
        try {
            QAFExtendedWebElement ele = this.getElement(loc, eleClass);
            switch (type) {
                case optionbox: {
                    return ele.getAttribute("value");
                }
                case checkbox: {
                    return ele.isSelected();
                }
                case selectbox: {
                    return new SelectBox(loc).getSelectedLable();
                }
                case multiselectbox: {
                    return new SelectBox(loc).getSelectedLables();
                }
            }
            return ele.getText();
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
            return "";
        }
    }

    public void fillValue(String loc, String val, UiElement.Type type, Class<? extends QAFExtendedWebElement> eleClass) {
        QAFExtendedWebElement ele = this.getElement(loc, eleClass);
        switch (type) {
            case textbox: 
            case textarea: {
                ele.clear();
                ele.sendKeys(new CharSequence[]{val});
                break;
            }
            case file: {
                ele.sendKeys(new CharSequence[]{val});
                break;
            }
            case checkbox: {
                boolean isChecked = ele.isSelected();
                if (Boolean.valueOf(val) == isChecked) break;
                ele.click();
                break;
            }
            case optionbox: {
                QAFExtendedWebElement opttionbox = this.getOptBox(loc, val, eleClass);
                boolean isSelected = opttionbox.isSelected();
                if (isSelected) break;
                opttionbox.click();
                break;
            }
            case selectbox: 
            case multiselectbox: {
                try {
                    QAFExtendedWebElement opt = this.getOptionElement(loc, val, eleClass);
                    if (opt.isSelected()) break;
                    opt.click();
                }
                catch (Exception exception) {
                    ele.sendKeys(new CharSequence[]{val});
                }
                break;
            }
        }
    }

    public boolean verifyValue(String loc, String val, UiElement.Type type, Class<? extends QAFExtendedWebElement> eleClass) {
        Object actualVal = null;
        try {
            actualVal = this.fetchValue(loc, type, eleClass);
            boolean result = StringUtil.seleniumEquals(String.valueOf(actualVal), val);
            this.report("value", result, val, actualVal);
            return result;
        }
        catch (Exception exception) {
            this.report("value", false, val, actualVal);
            return false;
        }
    }

    protected void report(String op, boolean outcome, Object ... args) {
        Reporter.log(WebDriverCommandLogger.getMsgForElementOp(op, outcome, args), outcome ? MessageTypes.Pass : MessageTypes.Fail);
    }

    private QAFExtendedWebElement getElement(String loc, Class<? extends QAFExtendedWebElement> eleClass) {
        try {
            Constructor<? extends QAFExtendedWebElement> con = eleClass.getConstructor(String.class);
            con.setAccessible(true);
            QAFExtendedWebElement ele = con.newInstance(loc);
            ele.waitForVisible(new long[0]);
            return ele;
        }
        catch (Exception e) {
            throw new AutomationError(e);
        }
    }

    private QAFExtendedWebElement getOptBox(String loc, String val, Class<? extends QAFExtendedWebElement> eleClass) {
        QAFExtendedWebElement ele = null;
        String xpath = "";
        if (loc.startsWith("//")) {
            xpath = loc;
        } else if (loc.indexOf("=") > 0) {
            String[] parts = loc.split("=", 2);
            if (parts[0].equalsIgnoreCase("name")) {
                xpath = "//input[@name='" + parts[1] + "']";
            } else if (parts[0].equalsIgnoreCase("id")) {
                xpath = "//input[@id='" + parts[1] + "']";
            } else if (parts[0].equalsIgnoreCase("xpath")) {
                xpath = parts[1];
            } else if (parts[0].equalsIgnoreCase("css")) {
                return new QAFExtendedWebElement(By.cssSelector((String)(String.valueOf(parts[1]) + "[value=" + val + "]")));
            }
        } else {
            xpath = String.format("//input[@name='%s' or @id='%s' or @value='%s']", loc, loc, loc);
        }
        ele = val.startsWith("lineNo=") ? new QAFExtendedWebElement(By.xpath((String)(String.valueOf(xpath) + "[" + val.split("=", 2)[1] + "]"))) : (val.startsWith("xpath=") ? new QAFExtendedWebElement(By.xpath((String)(String.valueOf(xpath) + "[" + val.split("=", 2)[1] + "]"))) : new QAFExtendedWebElement(By.xpath((String)(String.valueOf(xpath) + "[@value='" + val + "']"))));
        ele.waitForVisible(new long[0]);
        return ele;
    }

    private QAFExtendedWebElement getOptionElement(String loc, String val, Class<? extends QAFExtendedWebElement> eleClass) {
        String[] parts;
        String optLoc = !val.contains("=") ? (StringUtil.isNumeric((String)val) ? String.format(".//option[@value='%s' or @lineNo=%s or  @id='%s' or contains(.,'%s') ]", val, val, val, val) : String.format(".//option[translate(.,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s' or translate(@value,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s' or translate(@id,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s']", val.toUpperCase(), val.toUpperCase(), val.toUpperCase())) : ((parts = val.split("=", 2))[0].equalsIgnoreCase("label") || parts[0].equalsIgnoreCase("text") ? String.format(".//option[contains(.,'%s')]", parts[1]) : (parts[0].equalsIgnoreCase("lineNo") ? String.format(".//option[%d]", Integer.parseInt(parts[1]) + 1) : String.format(".//option[@%s='%s']", parts[0], parts[1])));
        return new QAFExtendedWebElement(this.getElement(loc, eleClass), By.xpath((String)optLoc));
    }

    public static class SelectBox
    extends QAFWebComponent {
        public SelectBox(String locator) {
            super(locator);
        }

        public List<QAFWebElement> getSelectedOptions() {
            return this.findElements("xpath=.//option[@selected]");
        }

        public List<QAFWebElement> getAllOptions() {
            return this.findElements("xpath=.//option");
        }

        public QAFWebElement getOption(String val) {
            String[] parts;
            String optLoc = !val.contains("=") ? (StringUtil.isNumeric((String)val) ? String.format(".//option[@value='%s' or @lineNo=%s or  @id='%s' or contains(.,'%s') ]", val, val, val, val) : String.format(".//option[translate(.,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s' or translate(@value,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s' or translate(@id,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')='%s']", val.toUpperCase(), val.toUpperCase(), val.toUpperCase())) : ((parts = val.split("=", 2))[0].equalsIgnoreCase("label") || parts[0].equalsIgnoreCase("text") ? String.format(".//option[contains(.,'%s')]", parts[1]) : (parts[0].equalsIgnoreCase("lineNo") ? String.format(".//option[%d]", Integer.parseInt(parts[1]) + 1) : String.format(".//option[@%s='%s']", parts[0], parts[1])));
            return this.findElement("xpath=" + optLoc);
        }

        public String getSelectedLable() {
            List<QAFWebElement> options = this.getSelectedOptions();
            return options.isEmpty() ? "" : options.get(0).getText();
        }

        public List<String> getSelectedLables() {
            ArrayList<String> labels = new ArrayList<String>();
            List<QAFWebElement> options = this.getSelectedOptions();
            for (QAFWebElement option : options) {
                labels.add(option.getText());
            }
            return labels;
        }
    }
}

