/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.integration;

import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class ResultUpdator
extends Thread {
    private static final Log logger = LogFactoryImpl.getLog(ResultUpdator.class);
    private Map<String, ?> params;
    private TestCaseRunResult result;
    private String details;
    private TestCaseResultUpdator updator;
    private static boolean hasActivePool = false;

    protected ResultUpdator() {
    }

    protected ResultUpdator(TestCaseRunResult result, String details, TestCaseResultUpdator updator, Map<String, ?> params2) {
        this.result = result;
        this.updator = updator;
        this.details = details;
        this.params = params2;
        logger.info((Object)String.format("Result updator: %s", params2));
    }

    @Override
    public void run() {
        try {
            System.out.println("started to updated result");
            this.updator.updateResult(this.params, this.result, this.details);
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to update result on " + this.updator.getToolName()), t);
        }
    }

    public static ThreadPoolExecutor getPool() {
        hasActivePool = true;
        return ExecutorHolder.INSTANCE;
    }

    public static int getActiveCount() {
        if (hasActivePool) {
            ResultUpdator.getPool().getActiveCount();
        }
        return 0;
    }

    public static void awaitTermination() {
        if (hasActivePool) {
            ThreadPoolExecutor pool = ResultUpdator.getPool();
            while (pool.getActiveCount() > 0) {
                logger.info((Object)("Result updator : Remaining " + pool.getActiveCount() + " result to be update."));
                try {
                    pool.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Result updator : Remaining " + pool.getActiveCount() + " result to be update.");
            try {
                pool.shutdownNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hasActivePool = false;
        }
    }

    public static void updateResult(TestCaseRunResult result, String assertLog, TestCaseResultUpdator toolUpdator, Map<String, ?> params2) {
        ResultUpdator updator = new ResultUpdator(result, assertLog, toolUpdator, params2);
        ResultUpdator.getPool().execute(updator);
    }

    private static class ExecutorHolder {
        private static final ThreadPoolExecutor INSTANCE = new ThreadPoolExecutor(0, 5, 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());

        private ExecutorHolder() {
        }
    }
}

